%define _name gupnp-av
%define ver_major 0.12

%def_disable static
%def_disable gtk_doc
%def_enable introspection

Name: libgupnp-av
Version: %ver_major.10
Release: alt0.M80P.1

Summary: A library to handle UPnP A/V profiles
Group: System/Libraries
License: LGPLv2+
Url: http://www.gupnp.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

BuildRequires: glib2-devel >= 2.14 gtk-doc
BuildRequires: libxml2-devel
BuildRequires: vala-tools rpm-build-vala libvala-devel
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel}

%description
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

GUPnP A/V is a small utility library that aims to ease the handling and
implementation of UPnP A/V profiles

%package devel
Summary: Development files and libraries for gUPnP-IGD
Group: Development/C
Requires: %name = %version-%release

%description devel
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

GUPnP A/V is a small utility library that aims to ease the handling and
implementation of UPnP A/V profiles.
This package provides files for development with gUPnP-AV.

%package devel-doc
Summary: Development documentaion for gUPnP-AV
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

GUPnP A/V is a small utility library that aims to ease the handling and
implementation of UPnP A/V profiles.
This package provides development documentations for gUPnP-AV.

%package gir
Summary: GObject introspection data for the GUPnP A/V library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GUPnP A/V library

%package gir-devel
Summary: GObject introspection devel data for the GUPnP A/V library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GUPnP A/V library


%prep
%setup -q -n %_name-%version
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure --disable-static \
%{?_enable_gtk_doc:--enable-gtk-doc} \
%{subst_enable introspection}

%make_build

%check
%make check

%install
%makeinstall_std

%files
%_libdir/*.so.*
%doc AUTHORS README ChangeLog
%_datadir/%_name

%files devel
%_pkgconfigdir/*
%_libdir/*.so
%_includedir/*
%_vapidir/*.deps
%_vapidir/*.vapi

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir
%endif


%changelog
