%define ver_major 3.24
%define api_ver 3.0
%def_disable static
%def_enable introspection
%def_enable vala

Name: libgweather
Version: %ver_major.1
Release: alt0.M80P.1

Summary: A library for weather information
Group: System/Libraries
License: GPLv3
Url: https://wiki.gnome.org/Projects/LibGWeather

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# From configure.ac
%define gtk_ver 3.13.5
%define glib_ver 2.35.1
%define intltool_ver 0.40.0
%define soup_ver 2.44
%define gir_ver 0.9.5
%define vala_ver 0.21.1

Requires: %name-data = %version-%release

BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libsoup-devel >= %soup_ver
BuildPreReq: intltool >= %intltool_ver
BuildPreReq: xsltproc
BuildPreReq: rpm-build-gnome gtk-doc
BuildRequires: libgeocode-glib-devel libxml2-devel perl-XML-Parser xml-utils gzip
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= %gir_ver libgtk+3-gir-devel}
%{?_enable_vala:BuildPreReq: vala-tools >= %vala_ver}
BuildRequires: libgladeui2.0-devel

%description
libgweather is a library to access weather information from online
services for numerous locations.

%package data
Summary: Locations data for %name
Group: System/Libraries
BuildArch: noarch

%description data
libgweather is a library to access weather information from online
services for numerous locations.

This package contains locations data for %name

%package devel
Summary: Development files for %name
Group: Development/GNOME and GTK+
# libgweather used to be part of gnome-applets, and
# gnome-applets-devel only had the libgweather-devel parts in it
Obsoletes: gnome-applets-gweather-devel < %version
Provides: gnome-applets-gweather-devel = %version
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-doc
The %name-devel-doc package contains documentation for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name library

%package gir-devel
Summary: GObject introspection devel data for the %name library
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the %name library

%package vala
Summary: Vala language bindings for the %name library
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release

%description vala
This package provides Vala language bindings for the %name library.

%prep
%setup

%build
# for tm.tm_gmtoff
%add_optflags -D_GNU_SOURCE
%configure \
    %{subst_enable static} \
    %{subst_enable vala}
%make_build

%install
%makeinstall_std

%find_lang --output=%name.lang %name-%api_ver
%find_lang --output=%name-locations.lang %name-locations

%check
%make check

%files -f %name.lang
%_libdir/*.so.*
%_datadir/glib-2.0/schemas/org.gnome.GWeather.enums.xml
%_datadir/glib-2.0/schemas/org.gnome.GWeather.gschema.xml
%doc AUTHORS NEWS README

%files data -f %name-locations.lang
%dir %_datadir/libgweather
%_datadir/libgweather/Locations.xml
%_datadir/libgweather/locations.dtd

%files devel
%_includedir/%name-%api_ver
%_libdir/*.so
%_pkgconfigdir/*
%_datadir/glade/catalogs/%name.xml

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/GWeather-%api_ver.typelib

%files gir-devel
%_girdir/GWeather-%api_ver.gir
%endif

%if_enabled vala
%files vala
%_vapidir/gweather-%api_ver.vapi
%endif


%changelog
