%define origname gwenhywfar
# Qt5 support is stiil failed to build
%def_without qt5

Name:     libgwenhywfar
Version:  4.15.3
Release:  alt1

Summary:  A multi-platform helper library for other libraries
Group:    System/Libraries
License:  LGPLv2+
URL:      http://www2.aquamaniac.de/sites/download/packages.php
# VCS:    http://git.aqbanking.de/git/gwenhywfar.git

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:   %origname-%version.tar
Source1:  %name.watch
Patch1:   %name-pthread.patch

BuildRequires: gcc-c++ glibc-devel graphviz libcom_err-devel 
BuildRequires: libgnutls-devel libssl-devel tzdata
BuildRequires: libqt4-devel libgtk+2-devel
%if_with qt5
BuildRequires: qt5-base-devel
%endif
BuildRequires: zlib-devel libgcrypt-devel ncurses-devel
BuildRequires: ca-certificates

Requires: ca-certificates

%description
This is Gwenhywfar, a multi-platform helper library for networking and
security applications and libraries. It is heavily used by libchipcard
www.libchipcard.de and OpenHBCI-TNG (The Next Generation)
www.openhbci.de.

Check http://www.freesource.info/wiki/Altlinux/Policy/TLS
for ALT Linux TLS/SSL policy

%package  gtk2
Summary:  Gwenhywfar support for GTK+
Group:    System/Libraries
Requires: %name = %version-%release

%description gtk2
Gwenhywfar support for GTK+

%package  qt4
Summary:  Gwenhywfar support for Qt4
Group:    System/Libraries
Requires: %name = %version-%release

%description qt4
Gwenhywfar support for Qt4

%if_with qt5
%package  qt5
Summary:  Gwenhywfar support for Qt5
Group:    System/Libraries
Requires: %name = %version-%release

%description qt5
Gwenhywfar support for Qt5
%endif

%package  devel
Summary:  Gwenhywfar development kit
Group:    Development/C
Requires: %name = %version-%release
Requires: %name-gtk2 = %version-%release
Requires: %name-qt4  = %version-%release
%if_with qt5
Requires: %name-qt5  = %version-%release
%endif

%description devel
This package contains gwenhywfar-config and header files for writing and
compiling programs using Gwenhywfar.

%prep
%setup -q -n %origname-%version
%patch1 -p2

%build
%autoreconf
%if_with qt5
export PATH=$PATH:%_qt5_bindir
%endif
%configure \
	--disable-static \
	--with-openssl-libs=%_libdir \
%if_with qt5
	--with-guis="gtk2 qt4 qt5" \
	--with-qt5-qmake=%_bindir/qmake-qt5 \
	--with-qt5-moc=%_bindir/moc-qt5 \
	--with-qt5-uic=%_bindir/uic-qt5 \
%else
	--with-guis="gtk2 qt4" \
%endif
	--with-qt4-libs="%_libdir"

%make_build

%install
%makeinstall_std
%find_lang %origname

# Use system-wide ca-certificates
rm -f %buildroot%_datadir/gwenhywfar/ca-bundle.crt
ln -s %_datadir/ca-certificates/ca-bundle.crt %buildroot%_datadir/gwenhywfar/ca-bundle.crt

%files -f %origname.lang
%doc AUTHORS README TODO
%_bindir/gct-tool
%_bindir/gsa
%_libdir/*.so.*
%exclude %_libdir/libgwengui-gtk2.so.*
%exclude %_libdir/libgwengui-qt4.so.*
%_libdir/%origname/
%_datadir/gwenhywfar/ca-bundle.crt
%_datadir/gwenhywfar/dialogs/*.dlg

%files gtk2
%_libdir/libgwengui-gtk2.so.*

%files qt4
%_libdir/libgwengui-qt4.so.*

%if_with qt5
%files qt5
%_libdir/libgwengui-qt5.so.*
%endif

%files devel
%_bindir/%origname-config
%_bindir/xmlmerge
%_bindir/mklistdoc
%_bindir/typemaker
%_bindir/typemaker2
%_libdir/*.so
%_includedir/gwenhywfar4/
%_pkgconfigdir/*
%_datadir/%origname/typemaker2/*
%_datadir/aclocal/gwenhywfar.m4
%_libdir/cmake/*

%changelog
