%define _name gypsy

Name: lib%_name
Version: 0.9
Release: alt2

Summary: A library for Gypsy
Group: System/Libraries
# See LICENSE file for details
License: LGPLv2 and GPLv2
Url: http://gypsy.freedesktop.org/
Source: http://gypsy.freedesktop.org/gypsy-releases/%_name-%version.tar.gz
Patch: gypsy-0.8-unusedvar.patch
Patch1: gypsy-0.9-alt-g_type_init.patch

BuildRequires: libbluez-devel
BuildRequires: libdbus-devel
BuildRequires: libdbus-glib-devel
BuildRequires: libgudev-devel
BuildRequires: glib2-devel
BuildRequires: gtk-doc
BuildRequires: libxslt

%description
Gypsy is a GPS multiplexing daemon which allows multiple clients to
access GPS data from multiple GPS sources concurrently. This package
provides shared library needed Gypsy to work.

This package provides shared library needed for Gypsy to work.

%package devel
Summary: Development package for gypsy
Group: Development/C
Requires: %name = %version-%release

%description devel
Header files for development with gypsy.

%package devel-doc
Summary: Documentation files for %name
Group: Development/C
Requires: %name = %version-%release
BuildArch: noarch

%description devel-doc
This package contains developer documentation for %name.

%package -n %_name-daemon
Group: Monitoring
Summary: A GPS multiplexing daemon
Requires: %name = %version-%release
Requires: dbus-tools-gui

%description -n %_name-daemon
Gypsy is a GPS multiplexing daemon which allows multiple clients to
access GPS data from multiple GPS sources concurrently.

%prep
%setup -q -n %_name-%version
%patch -p1
%patch1 -p1

%build
%configure --disable-static
%make_build

%install
%makeinstall_std

%files
%_libdir/libgypsy.so.0
%_libdir/libgypsy.so.0.0.0
%doc AUTHORS COPYING COPYING.lib LICENSE

%files -n %_name-daemon
%config %_sysconfdir/gypsy.conf
%_libexecdir/gypsy-daemon
%_sysconfdir/dbus-1/system.d/Gypsy.conf
%_datadir/dbus-1/system-services/org.freedesktop.Gypsy.service

%files devel
%_libdir/pkgconfig/gypsy.pc
%_includedir/gypsy
%_libdir/libgypsy.so

%files devel-doc
%_datadir/gtk-doc/html/gypsy

%changelog
