# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(HBAAPI) pkgconfig(pciaccess)
# END SourceDeps(oneline)
BuildRequires: pkgconfig(libudev)
%add_optflags %optflags_shared
Name:               libhbalinux
Version:            1.0.17
Release:            alt1_3
Summary:            FC-HBAAPI implementation using scsi_transport_fc interfaces
Group:              System/Libraries
License:            LGPLv2
URL:                http://www.open-fcoe.org
Source0:            %{name}-%{version}.tar.gz
Patch0:             libhbalinux-1.0.13-conf.patch
Patch1:             libhbalinux-fix-non-pci-netdev.patch
BuildRequires:      libhbaapi-devel >= 2.2.9
BuildRequires:      libpciaccess-devel libtool automake systemd-devel
Requires:           libhbaapi >= 2.2.9
Requires(post):     grep
Requires(postun):   grep
Source44: import.info

%description
SNIA HBAAPI vendor library built on top of the scsi_transport_fc interfaces.

%package devel
Summary:            A file needed for libhbalinux application development
Group:              Development/C
Requires:           %{name}%{?_isa} = %{version}
Requires:           pkgconfig

%description devel
The libhbalinux-devel package contains the library pkgconfig file.

%prep
%setup -q
%patch0 -p1
%patch1 -p1

%build
./bootstrap.sh
%configure --disable-static
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}
find %{buildroot} -name '*.la' -exec rm -f {} ';'

%post
ORG=org.open-fcoe.libhbalinux
LIB=%{_libdir}/libhbalinux.so.2.0.2
STR="$ORG	$LIB"
CONF=%{_sysconfdir}/hba.conf
if test -f $CONF; then
  grep -E -q ^[[:space:]]*$ORG[[:space:]]+$LIB $CONF
  if test $? -ne 0; then
    echo $STR >> $CONF;
  fi
fi

%postun
ORG=org.open-fcoe.libhbalinux
CONF=%{_sysconfdir}/hba.conf
if test -f $CONF; then
  grep -v $ORG $CONF > %{_sysconfdir}/hba.conf.new
  mv %{_sysconfdir}/hba.conf.new %{_sysconfdir}/hba.conf
fi

%files
%doc README COPYING
%{_libdir}/%{name}.so.*

%files devel
%{_libdir}/pkgconfig/%{name}.pc
%{_libdir}/%{name}.so

%changelog
