Name: libical1
Version: 1.0.1
Release: alt7

Summary: An implementation of basic iCAL protocols
Group: System/Libraries
License: LGPL2.1+/MPL
Url: https://github.com/%name

Source: %url/%name/releases/download/v%version/libical-%version.tar.gz
Patch: libical-1.0.1-alt-libdir.patch

BuildRequires: cmake gcc-c++ ctest

%description
Libical is an Open Source implementation of the IETF's iCalendar
Calendaring and Scheduling protocols (RFC 2445, 2446, and 2447).
It parses iCal components and provides a C API for manipulating the
component properties, parameters, and subcomponents

%package devel
Summary: Files for developing applications that use libical
Requires: %name = %version-%release
Group: Development/C
Conflicts: libical-devel > %version

%description devel
The header files and libtool library  for developing applications that
use libical.

%prep
%setup -n libical-%version
%patch -p1

%build
%cmake -DCMAKE_BUILD_TYPE:STRING="Release" \
	-DSHARED_ONLY:BOOL=ON
%cmake_build

%install
%cmakeinstall_std

%check
LD_LIBRARY_PATH=%buildroot%_libdir %make test -C BUILD

%files
%doc TODO TEST THANKS
%_libdir/*.so.*

%files devel
%doc doc/UsingLibical*
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/LibIcal/


%changelog
