Name: libisc-export-dhcp
Version: 9.9.9
Release: alt2.M80P.1

Summary: ISC BIND 9.9.x exportable libraries to build ISC DHCP
License: BSD-style
Group: System/Libraries
Url: http://www.isc.org/products/BIND/

%define vsuffix -P5
# NOTE: vsuffix removed from Source0
# ftp://ftp.isc.org/isc/bind9/%version%vsuffix/bind-%version%vsuffix.tar.gz
Source0: bind-%version.tar

# NB: there must be at least one patch :)
Patch0001: 0001-owl-warnings.patch
Patch0002: 0002-alt-owl-chroot.patch
Patch0003: 0003-alt-nofile.patch
Patch0004: 0004-fc-exportlib.patch
Patch0005: 0005-Fix-failover-initialization-in-dhcpd.patch

Obsoletes: libisc-export <= 9.9.9

%def_disable static
%def_enable ipv6
%def_with openssl

# due to broken configure script
BuildPreReq: gcc-c++

%{?_with_openssl:BuildPreReq: libssl-devel}

%package devel
Summary: ISC 9.9.x BIND development files for exportable libraries
Group: Development/C
Requires: %name = %version-%release
Obsoletes: libisc-export-devel <= 9.9.9

%description
This package contains shared libraries used to build ISC DHCP

%description devel
This package contains develompent files for ISC 9.9.x BIND libraries
used to build ISC DHCP.

%prep
%setup -n bind-%version

# NB: there must be at least one patch :)
%patch0001 -p2
%patch0002 -p2
%patch0003 -p2
%patch0004 -p2
%patch0005 -p2

# XXX oldish stuff introduced in 9.9.6
sed -i 's/AC_DEFINE(\(.*\), 1)/AC_DEFINE(\1, 1, [\1])/' configure.in

sed -i '/# Large File/iAC_SYS_LARGEFILE/' configure.in

%build
%autoreconf
%configure \
	--localstatedir=/var \
	--with-randomdev=/dev/random \
	--disable-threads \
	--disable-linux-caps \
	 %{subst_with openssl} \
	 %{subst_enable ipv6} \
	 %{subst_enable static} \
	--enable-rrl \
	--enable-fetchlimit \
	--enable-exportlib \
	--with-export-libdir=%{_libdir} \
	--with-export-includedir=%{_includedir} \
	--includedir=%{_includedir}/bind9 \
	--disable-openssl-version-check \
	--with-libtool \
	--with-gssapi=yes \
	--disable-isc-spnego \
	#

%make_build

%install
%makeinstall_std

%define _unpackaged_files_terminate_build 1

%files
%_libdir/lib*-export.so.*
%exclude %_sbindir/*
%exclude %_bindir/*
%exclude %_mandir/*/*
%exclude %_sysconfdir/*
%exclude %_libdir/libbind9.so*
%exclude %_libdir/libdns.so*
%exclude %_libdir/libisc.so*
%exclude %_libdir/libisccc.so*
%exclude %_libdir/libisccfg.so*
%exclude %_libdir/liblwres.so*

%files devel
%exclude %_includedir/bind9
%_includedir/*
%_libdir/lib*-export.so

%changelog
