%define _name json-glib
%define ver_major 1.2
%define api_ver 1.0
%def_disable gtk_doc
%def_disable static
%def_enable introspection

Name: lib%_name
Version: %ver_major.8
Release: alt0.M80P.1

Summary: GLib-based JSON manipulation library
Group: System/Libraries
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/JsonGlib

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

%define glib_ver 2.46.0
%define gi_ver 0.10.5
%{?_enable_static:BuildPreReq: glibc-devel-static}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
BuildRequires: glib2-devel >= %glib_ver gtk-doc

%description
JSON-GLib implements a full JSON parser using GLib and GObject. Use
JSON-GLib it is possible to parse and generate valid JSON data
structures, using a DOM-like API. JSON-GLib also offers GObject
integration, providing the ability to serialize and deserialize GObject
instances to and from JSON data types.

%package devel
Summary: Development files for %_name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the JSON-GLib library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the JSON-GLib library

%package gir-devel
Summary: GObject introspection devel data for the JSON-GLib library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the JSON-GLib library

%prep
%setup -n %_name-%version

%build
%configure \
    %{subst_enable static} \
    %{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%makeinstall_std

%find_lang --output=%_name.lang %_name-%api_ver

%check
%make check

%files -f %_name.lang
%_bindir/%_name-format
%_bindir/%_name-validate
%_libdir/*.so.*
%_man1dir/%_name-format.1.*
%_man1dir/%_name-validate.1.*
%doc NEWS ChangeLog

%files devel
%_libdir/*.so
%_libdir/pkgconfig/*
%_includedir/*
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/Json-%api_ver.typelib

%files gir-devel
%_girdir/Json-%api_ver.gir
%endif

%changelog
