%define _unpackaged_files_terminate_build 1
%def_with check
%def_with python3

%ifarch %arm %ix86 mips mipsel
%def_without mdb
%else
%def_with mdb
%endif

Name: libldb
Version: 1.4.8
Release: alt1
Summary: A schema-less, ldap like, API and database
License: LGPLv3+
Group: System/Libraries
Url: http://ldb.samba.org/

Source: http://samba.org/ftp/ldb/ldb-%{version}.tar.gz
Patch: ldb-samba-modules.patch
Patch1: ldb-alt-fix-python-ldflags.patch
Patch2: ldb-lmdb-disable-tests.patch

BuildRequires: python-devel python-module-tdb python-module-talloc-devel python-module-tevent
BuildRequires: libpopt-devel libldap-devel libcmocka-devel xsltproc docbook-style-xsl docbook-dtds
BuildRequires: libtdb-devel >= 1.3.16
BuildRequires: libtalloc-devel >= 2.1.14
BuildRequires: libtevent-devel >= 0.9.37
%if_with mdb
BuildRequires: liblmdb-devel >= 0.9.16
%endif

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-tdb
BuildRequires: python3-module-talloc-devel
BuildRequires: python3-module-tevent
%endif

Requires: libtdb >= 1.3.16
Requires: libtalloc >= 2.1.14
Requires: libtevent >= 0.9.37
%if_with mdb
Requires: liblmdb >= 0.9.16
%endif

%description
An extensible library that implements and LDAP like API to access remote LDAP
servers, or use local tdb databases.

%package devel
Group: Development/C
Summary: Developer tools for the LDB library
Requires: %name = %version-%release

%description devel
Header files needed to develop programs that link against the LDB library.

%package -n ldb-tools
Group: Development/Tools
Summary: Tools to manage LDB files
Requires: %name = %version-%release

%description -n ldb-tools
Tools to manage LDB files

%package -n python-module-pyldb
Group: Development/Python
Summary: Python bindings for the LDB library
Requires: %name = %version-%release

%description -n python-module-pyldb
Python bindings for the LDB library

%package -n python-module-pyldb-devel
Group: Development/Python
Summary: Development files for the Python bindings for the LDB library
Requires: python-module-pyldb = %version-%release
Requires: %name-devel = %version-%release

%description -n python-module-pyldb-devel
Development files for the Python bindings for the LDB library

%if_with python3
%package -n python3-module-pyldb
Group: Development/Python3
Summary: Python3 bindings for the LDB library
Requires: %name = %EVR

%description -n python3-module-pyldb
Python3 bindings for the LDB library

%package -n python3-module-pyldb-devel
Group: Development/Python3
Summary: Development files for the Python3 bindings for the LDB library
Requires: python3-module-pyldb = %EVR
Requires: %name-devel = %EVR

%description -n python3-module-pyldb-devel
Development files for the Python3 bindings for the LDB library
%endif

%prep
%setup -n ldb-%version
%patch -p2
%patch1 -p1

%if_without mdb
%patch2 -p2
%endif

%build
%undefine _configure_gettext
%configure	\
		--disable-rpath \
		--disable-rpath-install \
		--bundled-libraries=NONE \
		--builtin-libraries=replace \
		--with-modulesdir=%_libdir/ldb/modules \
		--with-samba-modulesdir=%_libdir/samba-dc \
%if_with python3
                --extra-python=python3 \
%endif
%if_without mdb
                --without-ldb-lmdb \
%endif
		--with-privatelibdir=%_libdir/ldb
%make

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.a
rm -f %buildroot/%_man3dir/_*

%check
make test

%files
%_libdir/libldb.so.*
%dir %_libdir/ldb
%dir %_libdir/ldb/modules
%dir %_libdir/ldb/modules/ldb

%_libdir/ldb/libldb-key-value.so
%if_with mdb
%_libdir/ldb/libldb-mdb-int.so
%endif

%_libdir/ldb/modules/ldb/asq.so
%_libdir/ldb/modules/ldb/ldap.so
%_libdir/ldb/modules/ldb/paged_results.so
%_libdir/ldb/modules/ldb/paged_searches.so
%_libdir/ldb/modules/ldb/rdn_name.so
%_libdir/ldb/modules/ldb/sample.so
%_libdir/ldb/modules/ldb/server_sort.so
%_libdir/ldb/modules/ldb/skel.so
%_libdir/ldb/modules/ldb/tdb.so
%_libdir/ldb/modules/ldb/ldb.so
%if_with mdb
%_libdir/ldb/modules/ldb/mdb.so
%endif

%files devel
%_includedir/ldb.h
%_includedir/ldb_errors.h
%_includedir/ldb_handlers.h
%_includedir/ldb_module.h
%_includedir/ldb_version.h
%_libdir/libldb.so
%_pkgconfigdir/ldb.pc
%_man3dir/ldb.3.*

%files -n ldb-tools
%_bindir/ldbadd
%_bindir/ldbdel
%_bindir/ldbedit
%_bindir/ldbmodify
%_bindir/ldbrename
%_bindir/ldbsearch
%_man1dir/ldbadd.1.*
%_man1dir/ldbdel.1.*
%_man1dir/ldbedit.1.*
%_man1dir/ldbmodify.1.*
%_man1dir/ldbrename.1.*
%_man1dir/ldbsearch.1.*
%_libdir/ldb/libldb-cmdline.so

%files -n python-module-pyldb
%python_sitelibdir/ldb.so
%python_sitelibdir/_ldb_text.py*
%_libdir/libpyldb-util.so.1*

%files -n python-module-pyldb-devel
%_includedir/pyldb.h
%_libdir/libpyldb-util.so
%_pkgconfigdir/pyldb-util.pc

%if_with python3
%files -n python3-module-pyldb
%python3_sitelibdir/ldb.cpython-*.so
%python3_sitelibdir/_ldb_text.py
%python3_sitelibdir/__pycache__/_ldb_text.cpython-*.py*
%_libdir/libpyldb-util.cpython-*.so.1*

%files -n python3-module-pyldb-devel
%_includedir/pyldb.h
%_libdir/libpyldb-util.cpython-*.so
%_pkgconfigdir/pyldb-util.cpython-*.pc
%endif

%changelog
