Name: liblensfun
Version: 0.3.2
Release: alt2

Summary: A library to rectifying the defects introduced by your photographic equipment
Group: System/Libraries
License: LGPLv3 and CC-BY-SA
Url: http://sourceforge.net/projects/lensfun/

Source: http://downloads.sourceforge.net/lensfun/lensfun-%version.tar.gz

BuildRequires: cmake gcc-c++ glib2-devel libpng-devel
BuildRequires: doxygen rpm-build-python3 python3-module-setuptools python3-module-docutils

%description
A library to rectifying the defects introduced by your photographic equipment.

%package devel
Summary: Development tools for programs which will use the lensfun library
Group: Development/C++
Requires: liblensfun = %version-%release

%description devel
Development tools for programs which will use the lensfun library.

%package tools
Summary: Tools for managing lensfun data
Group: Graphics
License: LGPLv3
BuildArch: noarch
Requires: %name = %version-%release

%description tools
This package contains tools to fetch lens database, updates and manage lens
adapters in lensfun.

%prep
%setup -n lensfun-%version
subst 's/rst2man/py3_rst2man.py/g' docs/CMakeLists.txt
subst 's/\t/      /' apps/lensfun-add-adapter

%build
%cmake \
	-DCMAKE_BUILD_TYPE:STRING=Release \
%ifnarch %ix86 x86_64
	-DBUILD_FOR_SSE:BOOL=OFF \
	-DBUILD_FOR_SSE2:BOOL=OFF \
%endif
	-DBUILD_TESTS:BOOL=OFF \
	-DBUILD_DOC:BOOL=ON

%cmake_build
%cmake_build man

%install
%cmakeinstall_std
pushd BUILD/apps/
%__python3 setup.py install --skip-build --root=%buildroot --prefix=%_prefix
popd

%files
%_libdir/%name.so.*
%_datadir/lensfun/
%doc ChangeLog README.*

%files devel
%_includedir/lensfun/
%_libdir/%name.so
%_pkgconfigdir/lensfun.pc
%doc %_datadir/doc/lensfun*/

%files tools
%_bindir/g-lensfun-update-data
%_bindir/lensfun-add-adapter
%_bindir/lensfun-update-data
%python3_sitelibdir_noarch/*
%_man1dir/*


%changelog
