Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
BuildRequires: /usr/bin/glib-gettextize /usr/bin/gtk-update-icon-cache /usr/bin/gtkdocize glib2-devel libgio-devel pkgconfig(gio-2.0) pkgconfig(gtk+-2.0) pkgconfig(gtk+-3.0) pkgconfig(libsoup-2.4) pkgconfig(libxml-2.0) python-devel
# END SourceDeps(oneline)
# for --enable-python
BuildRequires: python-module-pygobject-devel
BuildRequires: python-module-gudev
BuildRequires: python-module-pygtk-devel

%define _libexecdir %_prefix/libexec
Name:          libmateweather
Version:       1.12.1
Release:       alt1_1.M80P.2
Summary:       Libraries to allow MATE Desktop to display weather information
License:       GPLv2+ and LGPLv2+
URL:           http://mate-desktop.org
Source0:       http://pub.mate-desktop.org/releases/1.12/%{name}-%{version}.tar.xz

BuildRequires: gtk2-devel
BuildRequires: libsoup-devel
BuildRequires: mate-common
BuildRequires: python-module-pygtk-devel
BuildRequires: python-module-pygobject-devel

Requires:      %{name}-data = %{version}-%{release}
Source44: import.info
Patch33: libmateweather-1.12.1-gettext-not-xml.patch
Patch34: libmateweather-1.12.1-weather_service.patch

%description
Libraries to allow MATE Desktop to display weather information

%package data
Group: System/Libraries
Summary: Data files for the libmateweather
BuildArch: noarch
Requires: %{name} = %{version}-%{release}

%description data
This package contains shared data needed for libmateweather.

%package devel
Group: Development/C
Summary:  Development files for libmateweather
Requires: %{name}%{?_isa} = %{version}-%{release}

%description devel
Development files for libmateweather


%prep
%setup -q
%patch33 -p1
%patch34 -p2

%build
autoreconf -fisv
%configure --enable-python --disable-static           \
           --disable-schemas-compile  \
           --with-gtk=2.0             \
           --enable-gtk-doc-html      \
           --enable-python

# fix unused-direct-shlib-dependency
sed -i -e 's/ -shared / -Wl,-O1,--as-needed\0 /g' libtool 

make %{?_smp_mflags} V=1

%install
%{makeinstall_std}

find %{buildroot} -name '*.la' -exec rm -fv {} ';'
find %{buildroot} -name '*.a' -exec rm -fv {} ';'

%find_lang %{name} %{name}-locations --with-gnome --all-name
cat libmateweather-locations.lang >> %{name}.lang


%files
%doc AUTHORS COPYING README
%{_datadir}/glib-2.0/schemas/org.mate.weather.gschema.xml
%{_libdir}/libmateweather.so.1*
%{python_sitelibdir}/mateweather/

%files data -f %{name}.lang
%{_datadir}/icons/mate/*/status/*
%{_datadir}/libmateweather/

%files devel
%doc %{_datadir}/gtk-doc/html/libmateweather/
%{_libdir}/libmateweather.so
%{_includedir}/libmateweather/
%{_libdir}/pkgconfig/mateweather.pc


%changelog
