%define soversion 10

Name: libmirage
Version: 3.0.4
Release: alt1

Summary: A CD-ROM image access library
License: GPLv2+
Group: System/Libraries

URL: http://cdemu.sourceforge.net
Packager: Nazarov Denis <nenderus@altlinux.org>

Source0: http://downloads.sourceforge.net/cdemu/%name-%version.tar.bz2

BuildRequires: bzlib-devel
BuildRequires: cmake
BuildRequires: glib-networking
BuildRequires: gobject-introspection-devel
BuildRequires: gtk-doc
BuildRequires: libGConf
BuildRequires: liblzma-devel
BuildRequires: libsamplerate-devel
BuildRequires: libsndfile-devel
BuildRequires: time
BuildRequires: zlib-devel

%description
This is libMirage library, a CD-ROM image access library, and part of the 
userspace-cdemu suite, a free, GPL CD/DVD-ROM device emulator for linux. It is
written in C and based on GLib.

The aim of libMirage is to provide uniform access to the data stored in 
different image formats, by creating a representation of disc stored in image 
file, which is based on GObjects.

%package -n %name%soversion
Summary: A CD-ROM image access library
Group: System/Libraries

%description -n %name%soversion
This is libMirage library, a CD-ROM image access library, and part of the 
userspace-cdemu suite, a free, GPL CD/DVD-ROM device emulator for linux. It is
written in C and based on GLib.

The aim of libMirage is to provide uniform access to the data stored in 
different image formats, by creating a representation of disc stored in image 
file, which is based on GObjects.

%package devel
Summary: A CD-ROM image access library
Group: Development/C
Requires: glib2-devel

%description devel
This is libMirage library, a CD-ROM image access library, and part of the 
userspace-cdemu suite, a free, GPL CD/DVD-ROM device emulator for linux. It is
written in C and based on GLib.

This package contains files needed to develop with libMirage.

%prep
%setup -q

%build
%__mkdir_p %_target_platform
pushd %_target_platform

cmake .. \
         -DCMAKE_INSTALL_PREFIX:PATH="%prefix" \
         -DCMAKE_C_FLAGS:STRING="%optflags" \
         -DCMAKE_BUILD_TYPE:STRING="Release"
         
popd

%make_build -C %_target_platform

%install
%makeinstall_std -C %_target_platform

%files -n %name%soversion
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README
%_libdir/libmirage.so.*
%dir %_libdir/libmirage-3.0
%_libdir/libmirage-3.0/*.so
%_datadir/mime/packages/*.xml

%files devel
%_libdir/libmirage.so
%_libdir/girepository-1.0/*
%_pkgconfigdir/%name.pc
%dir %_includedir/%name-3.0
%dir %_includedir/%name-3.0/mirage
%_includedir/%name-3.0/mirage/*.h
%_datadir/gir-1.0/*
%dir %_datadir/gtk-doc
%dir %_datadir/gtk-doc/html
%doc %_datadir/gtk-doc/html/%name

%changelog
