%def_enable shared
%def_disable static
%def_with doc

%define sonum 1
%define libname libmpd

Name: %libname%sonum
Version: 11.8.90
Release: alt1.git20130319
Summary: Client library for MPD
License: GPLv2+
Group: System/Libraries
URL: http://gmpcwiki.sarine.nl/index.php/Libmpd
# git://repo.or.cz/libmpd.git
Source: %name-%version.tar

Provides: %libname

BuildRequires: glib2-devel
%{?_with_doc:BuildRequires: doxygen}

%description
Libmpd is an a library to easily connect to a Music Player Daemon
server. It's wraps around libmpdclient and provides a higher level API.
GMPC, Gnome Music Player Client, relies on this library to work with
MPD.


%package -n %libname-devel
Summary: Development environment for %libname
Group: Development/C
%if_enabled shared
Requires: %name = %version-%release
%else
Requires: %libname-devel-static = %version-%release
%endif

%description -n %libname-devel
This package contains the header files and libraries for building
programs that use %libname.


%if_enabled static
%package -n %libname-devel-static
Summary: Static %libname
Group: Development/C
Requires: %libname-devel = %version-%release

%description -n %libname-devel-static
This package contains static %libname.
%endif

%if_with doc
%package doc
Summary: Documentation for %libname
Group: Documentation
BuildArch: noarch

%description doc
This package contains documentation for %libname.
%endif

%prep
%setup

%build
%autoreconf
%configure \
    %{subst_enable shared} \
    %{subst_enable static} \
    --with-pic \
    --with-gnu-ld
%make_build all %{?_with_doc:doc}

%install
%makeinstall_std
%if_with doc
install -d -m 0755 %buildroot%_docdir/%name-%version/html
install -m 0644 ChangeLog %buildroot%_docdir/%name-%version/
install -m 0644 doc/html/* %buildroot%_docdir/%name-%version/html/
%endif

%if_enabled shared
%files
%_libdir/*.so.*
%endif

%files -n %libname-devel
%{?_enable_shared:%_libdir/*.so}
%_includedir/*
%_pkgconfigdir/*

%if_enabled static
%files -n %libname-devel-static
%_libdir/*.a
%endif

%if_with doc
%files doc
%_docdir/%name-%version
%endif

%changelog
