# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: libmpdclient
Version: 2.10
Release: alt1.git20140711

Summary: MPD client library
License: BSD-like
Group: System/Libraries
Url: http://mpd.wikia.com/wiki/ClientLib:libmpdclient

# git://repo.or.cz/libmpdclient.git
Source: %name-%version.tar.gz

BuildPreReq: doxygen graphviz libvala-devel

%description
Library for Music Player Daemon client development.

%package devel
Summary: Header files for the MPD client library
Group: Development/C
Requires: %name = %version-%release

%description devel
Header files for MPD client library.

%package devel-docs
Summary: Documentation for %name
Group: Development/Documentation
BuildArch: noarch

%description devel-docs
Development documentation for %name.

%package vala
Summary: Vala language bindings for %name
Group: Development/Other
BuildArch: noarch
Requires: %name = %EVR

%description vala
This package provides Vala language bindings for %name.

%prep
%setup

%build
%autoreconf
%configure \
	--disable-werror \
	--enable-static=no \
	--enable-debug
%make_build --no-print-directory

%check
%make_build --no-print-directory check

%install
%makeinstall_std --no-print-directory

%files
%doc README COPYING AUTHORS NEWS
%_libdir/%name.so.*.*.*
%ghost %_libdir/%name.so.?

%files devel
%_libdir/%name.so
%_includedir/mpd/
%_pkgconfigdir/%name.pc

%files devel-docs
%_docdir/%name

%files vala
%_vapidir/*

%changelog
