%def_disable static
%define sover 9

Name: libmtp
Version: 1.1.13
Release: alt0.M80P.1
Packager: Dmitriy Khanzhin <jinn@altlinux.ru>

Summary: a library for accessing Media Transfer Protocol devices

License: LGPLv2.1+
Group: System/Libraries
Url: http://libmtp.sourceforge.net/

Source: %name-%version.tar
Patch1: %name-%version-%release.patch

# Automatically added by buildreq on Sat Apr 18 2009
BuildRequires: libusb-devel

%package -n %name%sover
Summary: a library for accessing Media Transfer Protocol devices
Group: System/Libraries
Provides: %name = %version-%release
Obsoletes: %{name}7
Obsoletes: %name < %version-%release

%package -n %name-devel
Summary: %name development environment
Group: Development/C
Requires: %name = %version-%release

%package -n %name-devel-static
Summary: %name static development environment
Group: Development/C
Requires: %name-devel = %version-%release

%package -n %name-examples
Summary: %name usage examples
Group: Sound
Requires: %name = %version-%release

%description
Libmtp is a LGPL library implementation of the Media Transfer Protocol (MTP),
a superset of the Picture Transfer Protocol (PTP).

%description -n %name%sover
Libmtp is a LGPL library implementation of the Media Transfer Protocol (MTP),
a superset of the Picture Transfer Protocol (PTP).

%description -n %name-devel
This package contains all files which are needs to compile programs using
the %name library.

%description -n %name-devel-static
This package contains libraries which are needs to compile programs statically
linked against %name library.

%description -n %name-examples
This package contains example programs for communicating with MTP devices.

%prep
%setup
%patch1 -p1

%build
touch config.rpath
%autoreconf
%configure \
	%{subst_enable static} \
	--disable-mtpz \
	--with-udev=/lib/udev \
	--with-udev-group=audio \
	--with-udev-mode=0660

%make_build

%install
%make DESTDIR=%buildroot install

# Replace links with relative links
rm -f %buildroot%_bindir/mtp-{delfile,getfile,newfolder,sendfile,sendtr}
pushd %buildroot%_bindir
ln -sf mtp-connect mtp-delfile
ln -sf mtp-connect mtp-getfile
ln -sf mtp-connect mtp-newfolder
ln -sf mtp-connect mtp-sendfile
ln -sf mtp-connect mtp-sendtr
popd

rm -rf %buildroot%_docdir/%name-%version/html

%files -n %name%sover
%_libdir/*.so.*
/lib/udev/hwdb.d/*
/lib/udev/rules.d/*
/lib/udev/mtp-probe
%doc AUTHORS README TODO

%files -n %name-devel
%_includedir/*
%_pkgconfigdir/*
%_libdir/*.so

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%endif

%files -n %name-examples
%_bindir/*

%changelog
