# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define origname mysql++

Name: lib%origname
Version: 3.2.3
Release: alt0.M80P.1

Summary: C++ API for MySQL
License: LGPL
Group: System/Libraries

Url: http://tangentsoft.net/mysql++
Source: %url/releases/%origname-%version.tar.gz
Source100: libmysql++.watch
Patch: mysql++-gcc.patch
# http://lists.mysql.com/plusplus/9115 is not enough
Patch1: mysql++-3.1.0-as-needed.patch
Packager: Michael Shigorin <mike@altlinux.ru>

# Automatically added by buildreq on Sat Mar 29 2008
BuildRequires: gcc-c++ libMySQL-devel zlib-devel

Summary(ru_RU.UTF-8): C++ API для MySQL
Summary(uk_UA.UTF-8): C++ API для MySQL

%description
The goal of this API is to make working with queries as easy
as working with other STL Containers.

%description -l ru_RU.UTF-8
Целью этого API является возможность работы с запросами
как с обычными контейнерами STL.

%description -l uk_UA.UTF-8
Метою цього API є можливість роботи із запитами як із звичайними
контейнерами STL.

%package devel
Summary: C++ API for MySQL - development part
Summary(ru_RU.UTF-8): C++ API для MySQL - для разработчика
Summary(uk_UA.UTF-8): C++ API для MySQL - для розробника
Group: Development/C++
Requires: %name = %version-%release

%description devel
The goal of this API is to make working with queries as easy as
working with other STL Containers.

This package contains files needed to compile software
using %name as a share library.

%description devel -l ru_RU.UTF-8
Целью этого API является возможность работы с запросами
как с обычными контейнерами STL.

Этот пакет содержит файлы, которые нужны для компиляции программ,
которые используют %name как разделяемую библиотеку.

%description devel -l uk_UA.UTF-8
Метою цього API є можливість роботи із запитами як із звичайними
контейнерами STL.

Цей пакунок містить файли, що потрібні для компіляції програм,
які використовують %name як колективну бібліотеку.

%if_enabled static
%package devel-static
Summary: C++ API for MySQL - static development library
Summary(ru_RU.UTF-8): C++ API для MySQL - для разработчика (статическая часть)
Summary(uk_UA.UTF-8): C++ API для MySQL - для розробника (статична частина)
Group: Development/C++
Requires: %name-devel = %version-%release

%description devel-static
The goal of this API is to make working with queries as easy
as working with other STL Containers.

This package contains files needed to compile software
using %name in a statically-linked form.

%description devel-static -l ru_RU.UTF-8
Целью этого API является возможность работы с запросами
как с обычными контейнерами STL.

Этот пакет содержит файлы, которые нужны для компиляции программ,
которые компонуются с %name статически.

%description devel-static -l uk_UA.UTF-8
Метою цього API є можливість роботи із запитами як із звичайними
контейнерами STL.

Цей пакунок містить файли, що потрібні для компіляції програм,
які зкомпоновано із %name статично.

%endif

%prep
%setup -n %origname-%version
%patch -p1

%build
# FIXME: see http://lists.mysql.com/plusplus/9118
export LDFLAGS="$LDFLAGS -Wl,--no-as-needed"
%configure
%make_build

%install
%makeinstall

%files
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_includedir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

# TODO: have a closer look at fedora spec

%changelog
