Name: libmysqlclient16
Version: 5.1.65
Release: alt1

%def_without debug
%def_disable static
%define mysql_version %version
%define mysqld_user mysql
%define _libexecdir %_sbindir
%define ROOT %_localstatedir/mysql

Summary: MySQL: Shared libraries
License: LGPL
Group: System/Legacy libraries

Url: http://www.mysql.com
Source: mysql-%version.tar.gz
Packager: MySQL Development Team <mysql@packages.altlinux.org>

# ALTLinux
Patch0: mysql-3.23.55-alt-configure.patch
Patch1: mysql-5.1.50-alt-chroot.patch
Patch2: mysql-5.0.20-alt-libdir.patch
Patch4: mysql-5.0.67-alt-client.patch
Patch5: mysql-5.0.89-alt-load_defaults.patch
Patch6: mysql-5.1.50-alt-fPIC-innodb.patch
Patch7: mysql-5.1.56-alt-mysql_config-libs.patch
Patch8: mysql-5.1.56-alt-libmysql-cxa.patch
Patch9: mysql-5.1.56-alt-plugins-link.patch

# Automatically added by buildreq on Wed Mar 16 2011 (-bi)
BuildRequires: chrooted gcc-c++ libncursesw-devel libreadline-devel libssl-devel perl-DBI zlib-devel

Provides: libMySQL5.1 = %version
Obsoletes: libMySQL5.1 < %version

Summary(ru_RU.UTF-8): MySQL: Динамические библиотеки

%description -n libmysqlclient16
This package contains the shared libraries (*.so*) which certain
languages and applications need to dynamically load and use MySQL.

%prep
%setup -n mysql-%version
# ALTLinux
%patch0 -p1
%patch1 -p1
%patch2 -p1

%patch4 -p2
%patch5 -p2
%patch6 -p2
%patch7 -p2
%patch8 -p2
%patch9 -p2

# Use local regex.h header.
find -type f -print0 |
	xargs -r0 grep -FZl '<regex.h>' -- |
	xargs -r0 sed -i 's,<regex\.h>,"../regex/regex.h",g' --

# Prepare commands list for completion in mysql client.
sed -ne 's/^\(  { "[A-Z][^"]*"\).*/\1, 0, 0, 0, "" },/pg' <sql/lex.h >client/mysql_symbols.inc

find -type d -name CVS -print0 |
	xargs -r0 rm -rf --
find -type f -name .cvsignore -print0 |
	xargs -r0 rm -f --

chmod -R a-s,go-w sql-bench

%build
# Force HAVE_ERRNO_AS_DEFINE defined to wrong expansion
# of bits/errno.h's definition of errno in my_sys.h
%{!?_with_debug:%add_optflags %optflags_notraceback}
%add_optflags -D_FILE_OFFSET_BITS=64 -DHAVE_ERRNO_AS_DEFINE -DONE_THREAD
export CXXFLAGS="%optflags -felide-constructors -fno-exceptions -fno-rtti"

%autoreconf

# Precache these values to enable /proc-less build.
export \
	FIND_PROC='/bin/ps p $$PID | grep mysqld >/dev/null' \
	CHECK_PID='/bin/kill -0 $$PID >/dev/null 2>/dev/null' \
	#

%configure \
	--without-server \
	--localstatedir=%ROOT \
	--enable-assembler \
	--enable-shared \
	--enable-thread-safe-client \
	--without-readline \
	--without-mysqlfs \
	--enable-largefile=yes \
	--enable-large-files=yes \
	--with-archive-storage-engine \
	--with-blackhole-storage-engine \
	--without-example-storage-engine \
	%{subst_with debug} \
	%{subst_enable static} \
	--with-raid \
	--with-berkeley-db \
	--with-big-tables \
	--with-isam \
	--with-extra-charsets=all \
	--with-mysqld-user=%mysqld_user \
	--with-unix-socket-path=%ROOT/mysql.sock \
	--with-comment="%distribution MySQL RPM" \
	--with-plugin-innobase \
	--with-plugin-innodb_plugin \
	--with-plugin-partition \
	--with-ssl=%_prefix

%make_build

%install
%makeinstall_std
mv %buildroot%_libdir/mysql/libmysqlclient*.so.* %buildroot%_libdir/
rm -rf %buildroot/usr/{[^l]*,lib/mysql}/

%files
%_libdir/*.so.*

%changelog
