%define origname netwib

Name: libnetwib
Version: 5.39.0
Release: alt1

Summary: Functions for network programs
License: GPL
Group: System/Libraries

Url: http://www.laurentconstantin.com/en/netw/netwib/
Source: http://www.laurentconstantin.com/common/netw/netwib/download/v5/%origname-%version-src.tgz
Source1: html.tar

# Automatically added by buildreq on Wed Feb 15 2006
BuildRequires: libnet2-devel libpcap-devel

%description
Netwib provides most functions needed by network programs. Its objective is
to let programmers easily create network programs. This library provides
features for Ethernet, IPv4, IPv6, UDP, TCP, ICMP, ARP, and RARP protocols.
It supports spoofing, sniffing, client, and server creation. Furthermore,
netwib contains high level functions dealing with data handling.

This package contains the header files, the static library and development
documentation.

%package doc
Summary: Documentation for %name library
Group: Development/Documentation
BuildArch: noarch

%package devel
Summary: Headers and libraries for %name
Group: Development/C
Requires: %name = %version-%release

%description doc
The %name-doc package contains documntation of %name library

%description devel
The %name-devel package contains the header files and libraries needed
to develop programs that use the %name library.

%prep
%setup -n %origname-%version-src
tar -xf %SOURCE1

%build
cd src
./genemake
%make libnetwib.so

%install
rm -f doc/gpl.txt
cd src
%makeinstall INSTINCLUDE=%buildroot%_includedir \
	INSTLIB=%buildroot%_libdir \
	INSTBIN=%buildroot%_bindir \
	INSTMAN3=%buildroot%_man3dir \
	installso

%files
%doc doc/*.txt README.TXT
%_libdir/libnetwib*.so
%_man3dir/netwib*

%files doc
%doc html/*

%files devel
%_includedir/netwib*
%_bindir/netwib*-config

%changelog
