%define ver_major 0.7
%def_enable introspection

Name: libnotify
Version: %ver_major.7
Release: alt0.M80P.1

Summary: Desktop notification library
Group: System/Libraries
License: LGPLv2.1+
Url: http://live.gnome.org/libnotify

# git://git.gnome.org/libnotify
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Provides: %{name}4 = %version-%release
Obsoletes: %{name}4

BuildRequires: gtk-doc libgio-devel libgtk+3-devel xmlto
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgdk-pixbuf-gir-devel}

%description
The library that allows applications post notifications on the desktop
in accordance to the proposed Desktop Notification Specification.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Provides: %{name}4-devel = %version-%release
Obsoletes: %{name}4-devel

%description devel
Files needed to develop applications that use libnotify, a desktop
notification library.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version
Provides: %{name}4-devel-doc = %version-%release
Obsoletes: %{name}4-devel-doc

%description devel-doc
API documentation for %name in gtk-doc format.

%package gir
Summary: GObject introspection data for libnotify
Group: System/Libraries
Requires: %name = %version-%release
Provides: %{name}4-gir = %version-%release
Obsoletes: %{name}4-gir

%description gir
GObject introspection data for the desktop notification library.

%package gir-devel
Summary: GObject introspection devel data for libnotify
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release
Requires: %name-gir = %version-%release
Provides: %{name}4-gir-devel = %version-%release
Obsoletes: %{name}4-gir-devel

%description gir-devel
GObject introspection devel data for the desktop notification library.

%package -n notify-send
Summary: A program to send desktop notifications
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description -n notify-send
notify-send sends desktop notifications via a notification daemon from
the command line.

%prep
%setup
%patch -p1

[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
	--enable-gtk-doc \
	--disable-static \
	%{subst_enable introspection}
%make_build

%check
%make check

%install
%makeinstall_std

%files
%_libdir/*.so.*
%doc NEWS

%files -n notify-send
%_bindir/notify-send

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/Notify-%ver_major.typelib

%files gir-devel
%_girdir/Notify-%ver_major.gir
%endif

%changelog
