%define oname notify-sharp
Name: libnotify-sharp
Version: 0.4.0
Release: alt4.svn3037

License: X11/MIT
Url: http://trac.galago-project.org/wiki/DesktopNotifications
Packager: Mono Maintainers Team <mono@packages.altlinux.org>

Source: %oname-%version.tar.gz
Group: Development/Other
Summary: notify-sharp is a C# client implementation for Desktop Notifications

BuildRequires: libgcc libgtk-sharp2-devel mono-mcs ndesk-dbus-glib-devel monodoc-devel

BuildPreReq: rpm-build-mono
BuildRequires: /proc

%description
notify-sharp is a C# client implementation for Desktop Notifications,
i.e. notification-daemon. It is inspired by the libnotify API.

Desktop Notifications provide a standard way of doing passive pop-up
notifications on the Linux desktop. These are designed to notify the
user of something without interrupting their work with a dialog box
that they must close. Passive popups can automatically disappear after
a short period of time.

%package devel
Summary: Header files for %name
Group: Development/Other
Requires: %name = %version-%release

%description devel
Header files for %name library.

%package monodoc
Summary: Development documentation for %name
Group: Development/Other
BuildArch: noarch

%description monodoc
This package contains the API documentation for %name in Monodoc format.

%prep
%setup -n %oname-%version
%__subst "s|\$(DESTDIR)\$(libdir)|\$(DESTDIR)%_monodir/..|" src/Makefile.*

%build
%autoreconf
%configure --disable-static
%make

%install
%make_install DESTDIR=%buildroot install

%files
%doc AUTHORS COPYING ChangeLog NEWS README
%_monogacdir/*
%_monodir/notify-sharp

%files devel
%_pkgconfigdir/*

%files monodoc
%_monodocdir/%oname-docs.*

%changelog
