# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
Name: libnss-role
Version: 0.2.9
Release: alt0.M80P.1

Summary: NSS API library and admin tools for roles and privilegies

License: GPLv3
URL: http://tartarus.ru/projects/libnss-role
Group: System/Libraries
Packager: Pavel Shilovsky <piastry@altlinux.ru>

Source: %name-%version.tar

Requires(pre): chrooted >= 0.3.5-alt1 chrooted-resolv sed
Requires(postun): chrooted >= 0.3.5-alt1 sed

BuildRequires: glibc-devel scons
BuildRequires: libpam-devel

%description
NSS API library and admin tools for roles and privilegies.

%package devel
Summary: Header for developing applications managing Roles
Group: Development/Other
Requires: %name = %version-%release

%description devel
Headers for developing applications managing Roles throw
NSS API library for roles and privilegies.

%prep
%setup -q

%build
scons

%install
scons install DESTDIR=%buildroot LIBDIR=%_libdir LIBSYSDIR=/%_lib
mkdir -p %buildroot%_sysconfdir
install -m644 role.default %buildroot%_sysconfdir/role

%post
if [ "$1" = "1" ]; then
    grep -q '^group:[[:blank:]]*\(.\+[[:blank:]]\+\)*role\($\|[[:blank:]]\)' \
        %_sysconfdir/nsswitch.conf || \
    sed -i.rpmorig -e 's/^\(group:.\+\)$/\1 role/g' \
        %_sysconfdir/nsswitch.conf
fi
update_chrooted all

%postun
if [ "$1" = "0" ]; then
    sed -i -e 's/^group:role/group:/g' \
           -e 's/^\(group:\)\(.\+[[:blank:]]*\)*[[:blank:]]\+role\($\|[[:blank:]].*\)$/\1\2\3/g' \
        %_sysconfdir/nsswitch.conf
fi
update_chrooted all

%files
%config(noreplace) %_sysconfdir/role
%_sysconfdir/pam.d/role*
/%_lib/libnss_*.so.*
%_sbindir/*
%_bindir/*
%_libdir/*.so.*
%_man8dir/*

%files devel
%_libdir/*.so
%_includedir/role

%changelog
