# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
Name: libntirpc
Version: 1.5.2
Release: alt0.M80P.1

Summary: New Transport Independent RPC Library

Group: System/Libraries
License: BSD
Url: https://github.com/nfs-ganesha/ntirpc

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/nfs-ganesha/ntirpc/archive/v%version/ntirpc-%version.tar.gz
Source: %name-%version.tar

BuildRequires: cmake
BuildRequires: libjemalloc-devel
BuildRequires: libkrb5-devel

# libtirpc has /etc/netconfig, most machines probably have it anyway
# for NFS client
Requires: libtirpc

%description
This package contains a new implementation of the original libtirpc,
transport-independent RPC (TI-RPC) library for NFS-Ganesha. It has
the following features not found in libtirpc:
 1. Bi-directional operation
 2. Full-duplex operation on the TCP (vc) transport
 3. Thread-safe operating modes
 3.1 new locking primitives and lock callouts (interface change)
 3.2 stateless send/recv on the TCP transport (interface change)
 4. Flexible server integration support
 5. Event channels (remove static arrays of xprt handles, new EPOLL/KEVENT
    integration)

%package devel
Summary: Development headers for %name
Requires: %name = %version
Group: Development/Other

%description devel
Development headers and auxiliary files for developing with %name.

%prep
%setup

%build
%cmake -DOVERRIDE_INSTALL_PREFIX=%prefix -DTIRPC_EPOLL=1 -DUSE_GSS=ON "-GUnix Makefiles"

%make_build -C BUILD

%install
%makeinstall_std -C BUILD

rm -f %buildroot%_includedir/ntirpc/misc/winpthreads.h
ln -s %name.so.%version %buildroot%_libdir/%name.so.1

%files
%_libdir/libntirpc.so.*
%doc COPYING
%doc NEWS README

%files devel
%_libdir/libntirpc.so
%_includedir/ntirpc/
%_pkgconfigdir/libntirpc.pc

%changelog
