Packager: Repocop Q. A. Robot <repocop@altlinux.org>
%define libbuild 2
%define svnrev 505

%def_with utils
%def_enable shared
%def_enable static
#----------------------------------------------------------------------

%define Name NUT
Name: libnut
Version: 0.0
%define rel 1
%ifdef svnrev
Release: alt0.%svnrev.%rel.1.qa1
Source: %name-svn-r%svnrev.tar.bz2
%else
Release: alt%rel.1.qa1
Source: %name-%version.tar.bz2
%endif
Patch0: %name-svn-r505-makefile.patch
Patch1: %name-svn-r505-soname.patch
Summary: %Name open container format
URL: http://www.nut.hu
# svn checkout svn://svn.mplayerhq.hu/nut/trunk/libnut
License: MIT/X
Group: System/Libraries


%description
%Name is a container format under construction by MPlayer and FFmpeg
developers. Its main goals are to be simple to implement and parse,
easy to seek to precise position without unnecessary reads, even on
partial files, error resistant, and with the lowest possible overhead.

This package includes the shared library needed to run %name-based
software.


%if_with utils
%package utils
Group: Video
Summary: %Name utils
Provides: nut-utils = %version-%release
Obsoletes: nut-utils

%description utils
%Name is a container format under construction by MPlayer and FFmpeg
developers. Its main goals are to be simple to implement and parse,
easy to seek to precise position without unnecessary reads, even on
partial files, error resistant, and with the lowest possible overhead.

This package includes %name encoder utils.
%endif


%package devel
Summary: Development files of %Name library
Group: Development/C
Requires: %name%{?_disable_shared:-devel-static} = %version-%release

%description devel
%Name is a container format under construction by MPlayer and FFmpeg
developers. Its main goals are to be simple to implement and parse,
easy to seek to precise position without unnecessary reads, even on
partial files, error resistant, and with the lowest possible overhead.

This package includes the header files needed to develop %name-based
software.


%if_enabled static
%package devel-static
Summary: Static %Name library
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
%Name is a container format under construction by MPlayer and FFmpeg
developers. Its main goals are to be simple to implement and parse,
easy to seek to precise position without unnecessary reads, even on
partial files, error resistant, and with the lowest possible overhead.

This package includes the static library needed to develop
%name-based software.
%endif


%prep
%setup -q%{?svnrev: -n %name-svn-r%svnrev}
%patch0 -p1
%patch1 -p1


%build
%define _optlevel s
%add_optflags %optflags_shared
%make_build -C %name CFLAGS="%optflags" PREFIX=%prefix libdir=%_libdir %{?_enable_shared:%name.so} %{?_enable_static:%name.a}
%{?_with_utils:%make_build -C nututils CFLAGS="%optflags" PREFIX=%prefix libdir=%_libdir}


%install
%make_install DESTDIR=%buildroot PREFIX=%prefix libdir=%_libdir install
%if_with utils
install -d -m 0755 %buildroot%_bindir
install -m 0755 nututils/{nut{index,merge},avireader} %buildroot%_bindir/
%endif


%if_enabled shared
%files
%_libdir/*.so.*
%endif


%if_with utils
%files utils
%doc README
%_bindir/*
%endif


%files devel
%doc docs/*.txt
%_includedir/*
%{?_enable_shared:%_libdir/*.so}


%if_enabled static
%files devel-static
%_libdir/*.a
%endif


%changelog
