Name: libopenr2.3
Version: 1.3.0
Release: alt4

Summary: MFC/R2 call setup library
License: LGPL
Group: System/Libraries
Url: http://www.libopenr2.org/

Source: %name-%version-%release.tar

BuildRequires: dahdi-linux-headers

%description
OpenR2 is a library that implements the MFC/R2 signalling over E1 lines using
the Zapata Telephony interface. The MF R2 tones required for the signaling are
generated by code borrowed from the LGPL library SpanDSP written by Steve Underwood,
the user has the option to provide a MF interface to use his own MF R2 tone generation
and detection so the library will use them when needed, that's why this library does not
depend directly on spandsp, libteletone or zaptel for tone generation and detection
(depends on zaptel for ABCD bits and general media transmission though)

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Conflicts: libopenr2-devel

%package -n openr2-utils
Summary: OpenR2 utilities
Group: Networking/Other
Conflicts: libopenr2

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%description -n openr2-utils
OpenR2 is a library that implements the MFC/R2 signalling over E1 lines
using the Zapata Telephony interface.
This package contains OpenR2 utilities.

%prep
%setup 

%build
%autoreconf
%configure --sysconfdir=%_sysconfdir/openr2 --disable-static
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog COPYING COPYING.LESSER NEWS README TODO
%doc doc/*.alaw doc/README.asterisk

%_libdir/*.so.*

%files devel
%_includedir/openr2.h
%_includedir/openr2
%_libdir/*.so

%files -n openr2-utils
%dir %_sysconfdir/openr2
%config(noreplace) %_sysconfdir/openr2/r2test.conf
%config(noreplace) %_sysconfdir/openr2/r2proto.conf

%_bindir/r2test
%_bindir/r2dtmf_detect

%_man5dir/r2test.conf.5*
%_man8dir/r2test.8*

%changelog
