%def_enable snapshot
%define _name p11-kit
%define _libexecdir %_prefix/libexec

%def_enable trust_module
# the hash implementation -- freebl or internal
%define hash_impl freebl
%define trust_paths %_datadir/ca-certificates/ca-bundle.crt
#%%define trust_paths %_sysconfdir/pki/ca-trust/source:%_datadir/pki/ca-trust-source
%def_disable systemd

Name: lib%_name
Version: 0.23.8
Release: alt1.M80P.1

Summary: Library for loading and sharing PKCS#11 modules
Group: System/Libraries
License: BSD
Url: http://p11-glue.freedesktop.org/p11-kit.html

%if_enabled snapshot
# VCS: https://github.com/p11-glue/p11-kit.git
Source: %_name-%version.tar
%else
#Source: http://p11-glue.freedesktop.org/releases/%_name-%version.tar.gz
Source: https://github.com/p11-glue/%_name/releases/download/%version/%_name-%version.tar.gz
%endif

Source1: p11-kit-extract-trust
Patch: %name-0.23.8-alt-lfs.patch
Patch1: %name-0.23.8-proxy-refresh-slots.patch

Requires: ca-certificates
Requires: pkcs11-trust-module = %version-%release

BuildRequires: libtasn1-devel libffi-devel
%if %hash_impl == freebl
BuildRequires: libnss-devel
%endif
%{?_enable_systemd:BuildRequires: systemd-devel}
%{?_enable_doc:BuildRequires: gtk-doc}

%description
%_name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they\'re discoverable.

%package        trust
Summary: System trust module from %name package
Group: System/Libraries
Requires: %name = %version-%release
Provides: pkcs11-trust-module = %version-%release
#Conflicts: libnss < 3.14.3

%description    trust
The %name-trust package contains a system trust PKCS#11 module which
contains certificate anchors and black lists.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
%_name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they're discoverable.

The %name-devel package provides libraries and headers for developing
applications that use %_name library.

%package devel-doc
Summary: Development documentation for %_name
Group: Development/C
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
%_name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they\'re discoverable.

This package contains development documentation for %_name library.

%prep
%setup -n %_name-%version
%{?_enable_snapshot:NOCONFIGURE=1 ./autogen.sh}
%patch
%patch1 -p1

%build
%autoreconf
%configure --disable-static \
	--enable-debug=no \
	%{subst_enable trust_module} \
%if_enabled trust_module
	--with-libtasn1 \
	--with-trust-paths=%trust_paths \
%endif
	--with-hash-impl=%hash_impl \
	%{subst_enable doc}
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sysconfdir/pkcs11/modules
install -p -m755 %SOURCE1 %buildroot/%_libexecdir/%_name/

# alternatives
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_libdir/libnssckbi.so	%_libdir/pkcs11/p11-kit-trust.so 30
EOF

%check
#%make check

%files
%_bindir/%_name
%_bindir/trust
%_libdir/lib%_name.so.*
%_libdir/%_name-proxy.so
%dir %_libexecdir/%_name
%_libexecdir/%_name/p11-kit-remote
%dir %_datadir/%_name
%dir %_datadir/%_name/modules
%dir %_sysconfdir/pkcs11
%dir %_sysconfdir/pkcs11/modules

%if_enabled systemd
%_prefix/lib/systemd/user/%_name-remote.socket
%_prefix/lib/systemd/user/%_name-remote@.service
%_prefix/lib/systemd/user/sockets.target.wants/%_name-remote.socket
%endif

%_libdir/pkcs11/%_name-client.so
%_libexecdir/%_name/%_name-server
%doc %_name/pkcs11.conf.example
%doc AUTHORS COPYING NEWS README

%exclude %_sysconfdir/pkcs11/pkcs11.conf.example
%exclude %_libdir/pkcs11/*.la

%if_enabled trust_module
%files trust
%_libdir/pkcs11/%_name-trust.so
%_datadir/%_name/modules/%_name-trust.module
%_libexecdir/%_name/%_name-extract-trust
%_libexecdir/%_name/trust-extract-compat
#%_altdir/%name
%endif

%files devel
%_includedir/%_name-1
%_libdir/lib%_name.so
%_pkgconfigdir/%_name-1.pc

%if_enabled doc
%files devel-doc
%_datadir/gtk-doc/html/%_name
%endif

%changelog
