%define		srcname pion-net

%add_optflags -DBOOST_NO_CXX11_RVALUE_REFERENCES=1

Name:		lib%srcname
Version:	5.0.7
Release:	alt1.git20141017.1
Summary:	Pion Network Library (pion-net) is a C++ development library for implementing lightweight HTTP interfaces.
License: 	Boost Software License v1.0
Group: 		System/Libraries
Url:		http://sourceforge.net/projects/pion/
Source0:	%srcname-%version.tar

BuildRequires: boost-devel boost-asio-devel boost-filesystem-devel boost-interprocess-devel boost-signals-devel bzlib-devel doxygen gcc-c++ libicu-devel libssl-devel zlib-devel

BuildPreReq: python-modules python-devel
BuildPreReq: liblog4cplus-devel libxml2-devel graphviz

%description
Pion Network Library (pion-net) is a C++ development library for
implementing lightweight HTTP interfaces.
There are a wide variety of open source HTTP servers available,
from fast and lightweight servers such as lighttpd, to full-featured
platforms like Apache HTTPD. The motivation of pion-net is not to
implement yet another web server, but to provide HTTP(S) functionality
to new or existing C++ applications. If you're looking for a full-featured
server application, we suggest that you use one of the projects above.
If you're working on a Boost C++ application and would just like to
use HTTP to provide a simple user interface or interact with run-time
data, then pion-net is a much cleaner and simpler solution.

%package devel
Summary: Header files for %srcname library
Group: Development/C++
Requires: %name = %version-%release

%description devel
Header files for %srcname library

%package plugins
Summary: %srcname plugins
Group: System/Libraries

%description plugins
%srcname plugins

%package -n %srcname-servers
Summary: %srcname servers
Group: System/Servers
Requires: %srcname-data = %version-%release

%description -n %srcname-servers
%srcname servers

%package -n %srcname-data
Summary: Data files for %srcname
Group: System/Servers
BuildArch: noarch

%description -n %srcname-data
%srcname data

%package static
Summary: Static %srcname library
Group: Development/C++
Requires: %name-devel = %version-%release

%description static
Static %srcname library.

%package docs
Summary: %srcname documentation
Group: Documentation
BuildArch: noarch

%description docs
%srcname documnetation.

%prep
%setup -n %srcname-%version

%build
%add_optflags -fpermissive -std=gnu++11
export CPPFLAGS="%optflags"
./autogen.sh
%configure \
	--enable-static \
	--with-plugins=%_libdir/%srcname \
	--with-log4cplus \
	--with-zlib \
	--with-bzlib \
	--with-openssl \
	--with-libxml \
	--with-python=%_bindir/python \
	--enable-doxygen-dot \
	--enable-doxygen-man
%make_build V=1

%make docs

%install
%makeinstall_std
rm -rf %buildroot{%_libdir/%srcname/*.la,%_libdir/%srcname/*.a,%_libdir/*.la}

install -d %buildroot%_sysconfdir/pion
cp -fR platform/build/config/* %buildroot%_sysconfdir/pion/

install -d %buildroot%_datadir/pion
cp -fR platform/ui %buildroot%_datadir/pion/

install -d %buildroot%_docdir/%srcname
cp -fR doc/html doc/*.pdf AUTHORS ChangeLog NEWS *.md TODO *.html \
	%buildroot%_docdir/%srcname

%files
%_libdir/*.so

%files docs
%_docdir/%srcname

%files -n %srcname-servers
%_bindir/*
%dir %_sysconfdir/pion
%dir %_sysconfdir/pion/pymodules
%dir %_sysconfdir/pion/vocabularies
%config(noreplace) %_sysconfdir/pion/*.xml
%config(noreplace) %_sysconfdir/pion/logconfig.txt
%config(noreplace) %_sysconfdir/pion/*/*
%config %_sysconfdir/pion/sslkey.pem


%files -n %srcname-data
%_datadir/pion

%files plugins
%_libdir/%srcname

%files devel
%_includedir/pion
%_pkgconfigdir/*

%files static
%_libdir/*.a

# TODO: yajl support (need 2.0.5 minimum)

%changelog
