%define oname pjproject
Name: libpjsip
Version: 2.4.5
Release: alt4.1

Summary: Libraries for building embedded/non-embedded VoIP applications

License: GPLv2+
Group: System/Libraries
Url: http://www.pjsip.org

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://www.pjsip.org/release/%version/%oname-%version.tar
#Source: %name-%version.tar

# Nothing like carrying a 500k patch just to fix the FSF address :-)
Patch: pjproject_fix_old_FSF_address.patch
# Tell the build system not to use most of the third_party directory
Patch1: pjproject_no_third_party.patch
# Keep the .pc file clean
# see https://bugzilla.redhat.com/show_bug.cgi?id=728302#c66
Patch2: pjproject_fixup_pc_file.patch
# Fix ARMv7 endianness
Patch3: pjproject-armv7.patch
# Add aarch64
Patch4: pjproject-aarch64.patch
# Fix ppc64 endiannes
Patch5: pjproject-ppc64.patch

BuildRequires: gcc-c++
BuildRequires: libalsa-devel
BuildRequires: libgsm-devel
BuildRequires: libsrtp-devel
BuildRequires: libuuid-devel
BuildRequires: libssl-devel
BuildRequires: pkg-config
BuildRequires: libportaudio2-devel
# TODO: check for correct version
#BuildRequires: libresample-devel
BuildRequires: libspeex-devel
BuildRequires: libspeexdsp-devel

%description
This package provides the Open Source, comprehensive, high performance,
small footprint multimedia communication libraries written in C
language for building embedded/non-embedded VoIP applications.
It contains:
- PJSIP - Open Source SIP Stack
- PJMEDIA - Open Source Media Stack
- PJNATH - Open Source NAT Traversal Helper Library
- PJLIB-UTIL - Auxiliary Library
- PJLIB - Ultra Portable Base Framework Library
- PJSUA2 - Object Oriented abstractions layer for PJSUA

%package devel
Summary: Development files to use pjproject
Group: Development/Other
Requires: %name = %version-%release

%description devel
Header information for:
- PJSIP - Open Source SIP Stack
- PJMEDIA - Open Source Media Stack
- PJNATH - Open Source NAT Traversal Helper Library
- PJLIB-UTIL - Auxiliary Library
- PJLIB - Ultra Portable Base Framework Library

%prep
%setup -n %oname-%version
#patch0 -p1 -b .fsf
%patch1 -p1 -b .3rd
%patch2 -p1 -b .pkg
%patch3 -p1 -b .arm
%patch4 -p1 -b .aarch64
%patch5 -p1 -b .ppc64

# make sure we don't bundle these third-party libraries
# (They're excluded through ./configure, but this is an
# additional safety net)
rm -rf third_party/BaseClasses
rm -rf third_party/bdsound
rm -rf third_party/bin
rm -rf third_party/g7221
rm -rf third_party/gsm
rm -rf third_party/milenage
rm -rf third_party/mp3
rm -rf third_party/portaudio
#rm -rf third_party/resample
rm -rf third_party/speex
rm -rf third_party/srtp
rm -rf third_party/ilbc
rm -rf third_party/build/baseclasses
rm -rf third_party/build/g7221
rm -rf third_party/build/gsm
rm -rf third_party/build/milenage
rm -rf third_party/build/portaudio/src
#rm -rf third_party/build/resample
rm -rf third_party/build/samplerate
rm -rf third_party/build/speex
rm -rf third_party/build/srtp
rm -rf third_party/build/ilbc

%build
# We're building without audio or video support, as Asterisk isn't using
# that functionality, and it made it easier to ensure that we don't
# bundle any unnecessary libraries.  Please contact me if your project
# needs this support, and I'll re-enable it
export CFLAGS="-DPJ_HAS_IPV6=1 ${ARCHFLAGS} %optflags"

%configure --enable-shared        \
           --disable-static       \
           --with-external-gsm    \
           --with-external-pa     \
           --with-external-speex  \
           --with-external-srtp   \
           --disable-opencore-amr \
           --enable-resample      \
           --enable-sound         \
           --disable-video        \
           --disable-v4l2         \
           --disable-ilbc-codec   \
           --disable-libyuv       \
           --disable-g7221-codec

%make_build dep
%make_build

%install
%makeinstall_std

# Remove the static libraries, as they aren't wanted
find %buildroot -type f -name "*.a" -delete
# random extras due to patching for the FSF address change
find %buildroot -type f -name "*.fsf" -delete

# rpmlint complains that this is an empty file, so let's fix that
echo "" >> %buildroot%_includedir/pj/config_site.h

%files
%doc README.txt README-RTEMS
%attr(755, root, root) %_libdir/lib*.so.*

%files devel
%_libdir/lib*.so
%_includedir/pj++/
%_includedir/pj/
%_includedir/pjlib-util/
%_includedir/pjmedia-audiodev/
%_includedir/pjmedia-codec/
%_includedir/pjmedia-videodev/
%_includedir/pjmedia/
%_includedir/pjnath/
%_includedir/pjsip-simple/
%_includedir/pjsip-ua/
%_includedir/pjsip/
%_includedir/pjsua-lib/
%_includedir/pjsua2/
%_includedir/*.h
%_includedir/*.hpp
%_pkgconfigdir/libpjproject.pc

%changelog
