%def_disable python3

Name: libplist
Version: 2.0.0
Release: alt0.M80P.1

Summary: Library for manipulating Apple Binary and XML Property Lists
Group: System/Libraries
License: LGPLv2+
Url: http://www.libimobiledevice.org/

Source: %url/downloads/%name-%version.tar.bz2

BuildRequires: gcc-c++ cmake xml-utils
BuildRequires: python-devel python-module-Cython
%{?_enable_python3:BuildRequires: python3-devel rpm-build-python3 python3-module-Cython}

%description
libplist is a library for manipulating Apple Binary and XML Property Lists

%package -n %{name}mm
Summary: Cmm wrapper for %name library
Group: System/Libraries
Requires: %name = %version-%release

%description -n %{name}mm
This package provides Cmm interface for %name library

%package -n %{name}mm-devel
Summary: Headers and development files for %{name}mm library
Group: System/Libraries
Requires: %{name}mm = %version-%release
Requires: %name-devel = %version-%release

%description -n %{name}mm-devel
This package contains the headers and development files that are needed
to develop or compile applications which need %{name}mm library

%package devel
Summary: Development package for libplist
Group: Development/C
Requires: %name = %version-%release

%description devel
This package provides development headers and libraries for %name

%package -n python-module-%name
Summary: Python package for libplist
Group: Development/Python
Requires: %name = %version-%release
Requires: %{name}mm = %version-%release

%description -n python-module-%name
Python libraries and bindings for %name

%package -n python3-module-%name
Summary: Python3 package for libplist
Group: Development/Python3
Requires: %name = %version-%release
Requires: %{name}mm = %version-%release

%description -n python3-module-%name
Python3 libraries and bindings for %name


%prep
%setup -a0
# for python2 only
subst 's/\(PYTHON-config --ldflags\)/\1 -lpython%__python_version/' m4/ac_python_devel.m4
mv %name-%version py3build

%build
%autoreconf
%configure --disable-static
%make_build

%if_enabled python3
pushd py3build
%add_optflags %optflags_shared
%autoreconf
%configure --disable-static PYTHON=%__python3
%make_build
popd
%endif

%install
%makeinstall_std

%if_enabled python3
pushd py3build
%makeinstall_std
popd
%endif

%files
%_bindir/plistutil
%_libdir/libplist.so.*
%doc AUTHORS README

%files devel
%_includedir/plist/
%_libdir/libplist.so
%_libdir/pkgconfig/libplist.pc
%exclude %_includedir/plist/plist++.h

%files -n %{name}mm
%_libdir/libplist++.so.*

%files -n %{name}mm-devel
%_includedir/plist/plist++.h
%_libdir/libplist++.so
%_libdir/pkgconfig/libplist++.pc

%files -n python-module-%name
%python_sitelibdir/plist.so
%exclude %python_sitelibdir/plist.la

%if_enabled python3
%files -n python3-module-%name
%python3_sitelibdir/plist.so
%exclude %python3_sitelibdir/plist.la
%endif

%changelog
