Name: libpng
Version: 1.5.28
Release: alt1

Summary: A library of functions for manipulating PNG image format files
License: zlib
Group: System/Libraries
Url: http://www.libpng.org/pub/png/

# git://git.altlinux.org/gears/l/%name.git
Source: %name-%version-%release.tar

%def_disable static

# Automatically added by buildreq on Tue Feb 08 2011
BuildRequires: zlib-devel

%package -n libpng15
Summary: PNG runtime library
Group: System/Libraries
Provides: libpng = %version
# due to %_man5dir/*
Conflicts: libpng12 < 1.2.50-alt2

%package devel
Summary: PNG development library
Group: Development/C
Requires: libpng15 = %version-%release, zlib-devel
Conflicts: libpng12-devel

%package devel-static
Summary: PNG static library
Group: Development/C
Requires: %name-devel = %version-%release, zlib-devel-static

%description
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

%description -n libpng15
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package contains the runtime library files needed to run software
using libpng.

%description devel
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package contains the header and development files needed to build
programs and packages using libpng.

%description devel-static
This package contains static library necessary for developing statically
linked programs using the PNG (Portable Network Graphics) library.

%prep
%setup -n %name-%version-%release

%build
%autoreconf
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std
rm %buildroot%_libdir/lib*.la

%define docdir %_docdir/libpng-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -p -m644 CHANGES LICENSE README TODO example.c libpng*.txt \
	%buildroot%docdir/
xz -9 %buildroot%docdir/*.txt %buildroot%docdir/CHANGES

%check
%make_build -k check

%files -n libpng15
%_libdir/*.so.*
%_man5dir/*
%dir %docdir
%docdir/[CLR]*

%files devel
%_bindir/*-config
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*
%docdir
%exclude %docdir/[CLR]*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
