Summary: Prelude Hybrid Intrusion Detection System Library
Name: libprelude
Version: 1.2.6rc1
Release: alt1.git20140916.qa5.M80P.2
License: GPLv2
Group: System/Libraries
Url: http://www.prelude-ids.org/

Source: %name-%version.tar
# Ubuntu
Patch1: gcc5.diff

%def_enable static
%{?_enable_static:BuildPreReq: glibc-devel-static}
%def_enable gtk_doc
%define _gtk_docdir %_datadir/gtk-doc/html
%{?_enable_gtk_doc:BuildPreReq: gtk-doc}

# Automatically added by buildreq on Mon Oct 17 2011
BuildRequires: gcc-c++ libgcrypt-devel libgnutls-devel libltdl7-devel liblua5-devel perl-devel python-devel swig glib2-devel

BuildPreReq: flex gtk-doc-mkpdf

%description
The Prelude Library is a collection of generic functions providing
communication between the Prelude Hybrid IDS suite components. It
provides a convenient interface for sending alerts to Prelude Manager
with transparent SSL, failover and replication support, asynchronous
events and timer interfaces, an abstracted configuration API (hooking
at the commandline, the configuration line, or wide configuration,
available from the Manager), and a generic plugin API. It allows you
to easily turn your favorite security program into a Prelude sensor.

%description -l ru_RU.UTF-8
Библиотека Prelude содержит коллекцию общих функций, обеспечивающих
коммуникацию между компонентами Prelude Hybrid IDS. Она обеспечивает
интерфейс для пересылки предупреждений менеджеру Prelude используя
SSL, отказоустойчивость и поддержку репликаций, асинхронные события и
интерфейсы таймера, абстрактный конфигурационный API и общий API для
дополнений. Это позволит вам легко интегрировать вашу программу
безопасности в датчик Prelude.

%description -l uk_UA.UTF-8
Бібліотека Prelude містить колекцію спільних функцій, що забезпечують
комунікацію між компонентами Prelude Hybrid IDS. Вона забезпечує
інтерфейс для надсилання попереджень менеджеру Prelude використовуючи
SSL, відмовостійкість і підтримку реплікацій, асинхронні події та
інтерфейси таймера, абстрактний конфігураційний API та загальний API
для доповнень. Це дозволить вам легко інтегрувати вашу програму
безпеки в датчик Prelude.

%package devel
Summary: Libraries, includes, etc. to develop Prelude IDS sensors
Group: Development/C
Requires: %name = %version-%release

%description devel
Libraries, include files, etc you can use to develop Prelude IDS sensors using
the Prelude Library. The Prelude Library is a collection of generic functions
providing communication between the Prelude Hybrid IDS suite componentst
It provides a convenient interface for sending alerts to Prelude Manager with
transparent SSL, failover and replication support, asynchronous events and
timer interfaces, an abstracted configuration API (hooking at the commandline,
the configuration line, or wide configuration, available from the Manager), and
a generic plugin API. It allows you to easily turn your favorite security
program into a Prelude sensor.

%description -l ru_RU.UTF-8 devel
Библиотеки, заголовочные файлы и т.п вы можете использовать для
разработки датчиков Prelude IDS. Библиотека Prelude содержит коллекцию
общих функций, обеспечивающих коммуникацию между компонентами Prelude
Hybrid IDS. Она обеспечивает интерфейс для пересылки предупреждений
менеджеру Prelude используя SSL, отказоустойчивость и поддержку
репликаций, асинхронные события и интерфейсы таймера, абстрактный
конфигурационный API и общий API для дополнений. Это позволит вам
легко интегрировать вашу программу безопасности в датчик Prelude.

%description -l uk_UA.UTF-8 devel
Бібліотеки, файли заголовків і т.п ви можете використовувати для
розробки датчиків Prelude IDS. Бібліотека Prelude містить колекцію
спільних функцій, що забезпечують комунікацію між компонентами Prelude
Hybrid IDS. Вона забезпечує інтерфейс для надсилання попереджень
менеджеру Prelude використовуючи SSL, відмовостійкість і підтримку
реплікацій, асинхронні події та інтерфейси таймера, абстрактний
конфігураційний API та загальний API для доповнень. Це дозволить вам
легко інтегрувати вашу програму безпеки в датчик Prelude.

%if_enabled static
%package devel-static
Summary: Static libraries to develop Prelude IDS sensors
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
Static libraries to develop Prelude IDS sensors using the Prelude Library.
%endif

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name-devel < %version-%release
BuildArch: noarch

%description devel-doc
Libraries, include files, etc you can use to develop Prelude IDS sensors using
the Prelude Library. The Prelude Library is a collection of generic functions
providing communication between the Prelude Hybrid IDS suite componentst
It provides a convenient interface for sending alerts to Prelude Manager with
transparent SSL, failover and replication support, asynchronous events and
timer interfaces, an abstracted configuration API (hooking at the commandline,
the configuration line, or wide configuration, available from the Manager), and
a generic plugin API. It allows you to easily turn your favorite security
program into a Prelude sensor.

This package contains development documentation for the library.

%package -n python-module-%name
Summary: Development package that includes the %name header files
Group: Development/Python
Requires: %name = %version-%release

%description -n python-module-%name
The devel package contains the %name library and the include files

%package -n perl-%name
Summary: Libraries and modules for access to %name from perl
Group: Development/Perl
Requires: %name = %version-%release

%description -n perl-%name
Perl bindings to %name.
Install perl-%name if you want to use any perl scripts that use %name.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure %{subst_enable static} \
	--localstatedir=%_var \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--with-perl-installdirs=vendor \
	--enable-threads=posix \
	--disable-rpath

rm -fR libltdl
sed -i 's|^\(CFLAGS =.*\)|\1 -include %_includedir/stdio.h|' \
	$(find ./ -name Makefile)
%make_build

%install
%makeinstall_std

# Fix time stamp for both 32 and 64 bit libraries
touch -r ./configure.in %buildroot%_sysconfdir/prelude/default/*

# disable broken library
rm -f %buildroot%_libdir/PreludeEasy.*

%files
%doc README LICENSE.README AUTHORS COPYING NEWS HACKING.README
%_bindir/prelude-adduser
%_bindir/prelude-admin
%_libdir/%{name}*.so.*
#_libdir/PreludeEasy.so
%config(noreplace) %_sysconfdir/prelude
%_man1dir/*
%dir %_spooldir/*

%if_enabled static
%files devel-static
%_libdir/%{name}*.a
#_libdir/PreludeEasy.a
%endif

%files devel
%_bindir/%name-config
%_libdir/%{name}*.so
%_includedir/%name
%_datadir/aclocal/*
%_datadir/%name
%_libdir/pkgconfig/%name.pc

%files devel-doc
%_gtk_docdir/*

%files -n python-module-%name
%python_sitelibdir/*

%files -n perl-%name
%perl_vendor_autolib/Prelude*
%perl_vendor_archlib/Prelude*

%changelog
