%define rname pugixml

Name: libpugixml
Version: 1.7
Release: alt1
Summary: A light-weight C++ XML processing library

Group: System/Libraries
License: MIT
Url: http://pugixml.org

Source0: %rname-%version.tar.gz

BuildRequires: ctest cmake
BuildRequires: gcc-c++
Provides: %rname = %version-%release

%description
pugixml is a light-weight C++ XML processing library.
It features:
- DOM-like interface with rich traversal/modification capabilities
- Extremely fast non-validating XML parser which constructs the DOM tree
  from an XML file/buffer
- XPath 1.0 implementation for complex data-driven tree queries
- Full Unicode support with Unicode interface variants and automatic
  encoding conversions

%package devel
Summary: Development files for %name
Group: Development/Other
Requires: %name = %version-%release
Provides: %rname-devel = %version-%release

%description devel
Development files for package %name

%prep
%setup -n %rname-%version
cp scripts/CMakeLists.txt .

%build
%cmake -DBUILD_SHARED_LIBS=1 ../scripts
%cmake_build

%install
%cmakeinstall_std

%files
%doc readme.txt
%_libdir/*.so.*

%files devel
%doc docs/*
%_libdir/*.so
%_libdir/cmake/pugixml/
%_includedir/*.hpp

%changelog
