%define _qt4_translationdir %_datadir/qt4/translations

%define oname qtspell
Name: libqtspell
Version: 0.8.2
Release: alt0.M80P.1

Summary: Spell checking for Qt text widgets

License: GPLv3+
Group: Text tools
Url: https://github.com/manisandro/qtspell

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://github.com/manisandro/qtspell/releases/download/%version/%oname-%version.tar

# manually removed: i586-libxcb libfreetype-infinality libqt4-sql-interbase libqt4-sql-mysql libqt4-sql-odbc libqt4-sql-postgresql libqt4-sql-sqlite2 libqt4-webkit-devel phonon-devel python3 python3-module-zope qt4-designer qt5-imageformats qt5-tools-devel ruby ruby-stdlibs
# Automatically added by buildreq on Sat Aug 15 2015
# optimized out: cmake cmake-modules fontconfig glib2-devel libEGL-devel libGL-devel libqt4-core libqt4-devel libqt4-gui libqt4-network libqt4-opengl libqt4-qt3support libqt4-script libqt4-sql-sqlite libqt4-svg libqt5-core libqt5-gui libqt5-widgets libqt5-xml libstdc++-devel pkg-config python3-base qt5-base-devel qt5-tools
BuildRequires: ccmake doxygen gcc-c++ graphviz libenchant-devel

BuildRequires: cmake
BuildRequires: libqt4-devel
BuildRequires: qt5-base-devel
BuildRequires: qt5-tools-devel

Requires: iso-codes

%description
QtSpell adds spell-checking functionality to Qt's text widgets, using the
enchant spell-checking library.

%package qt4
Group: Text tools
Summary: Spell checking for Qt4 text widgets

%description qt4
QtSpell adds spell-checking functionality to Qt4's text widgets, using the
enchant spell-checking library.

%package qt4-devel
Group: Text tools
Summary: Development files for %name-qt4
Requires: %name-qt4 = %version-%release

%description qt4-devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package qt5
Group: Text tools
Summary: Spell checking for Qt5 text widgets

%description qt5
QtSpell adds spell-checking functionality to Qt5's text widgets, using the
enchant spell-checking library.

%package qt5-devel
Group: Text tools
Summary: Development files for %name-qt5
Requires: %name-qt5 = %version-%release

%description qt5-devel
The %name-qt5-devel package contains libraries and header files for
developing applications that use %name-qt5.

%package qt5-translations
Group: Text tools
Summary: Translations for %name-qt5
BuildArch: noarch
Requires: %name-qt5 = %version-%release
Requires: qt5-translations

%description qt5-translations
The %name-qt5-translations contains translations for %name-qt5.

%package doc
Group: Text tools
Summary: Developer documentation for %name
BuildArch: noarch

%description doc
The %name-doc package contains the documentation for developing applications
that use %name.

%prep
%setup -n %oname-%version

%build
%cmake
%cmake_build
%cmake_build doc
mv BUILD build-qt4

%cmake -DUSE_QT5=ON
%cmake_build
mv BUILD build-qt5

%install
# install qt4 build
rm -rf BUILD
cp -al build-qt4 BUILD
%cmakeinstall_std

# install qt5 build
rm -rf BUILD
cp -al build-qt5 BUILD
%cmakeinstall_std

%files qt4
%doc COPYING
%_libdir/libqtspell-qt4.so.*
%_qt4_translationdir/QtSpell_*.qm

%files qt4-devel
%_includedir/QtSpell-qt4/
%_libdir/libqtspell-qt4.so
%_pkgconfigdir/QtSpell-qt4.pc

%files qt5
%doc COPYING
%_libdir/libqtspell-qt5.so.*

%files qt5-devel
%_includedir/QtSpell-qt5/
%_libdir/libqtspell-qt5.so
%_pkgconfigdir/QtSpell-qt5.pc

%files qt5-translations
%_qt5_translationdir/QtSpell_*.qm

%files doc
%doc COPYING
%doc build-qt4/doc/html

%changelog
