%define _name LibRaw

Name: libraw
Version: 0.17.2
Release: alt1

Summary: library for reading RAW files obtained from digital photo cameras
Group: System/Libraries
License: CDDL LGPL LibRaw, GPLv2 GPLv3 - demosaic packs

Url: http://www.libraw.org

Source: %url/data/%_name-%version.tar.gz
#Source: %name-%version.tar
Source1: %url/data/%_name-demosaic-pack-GPL2-%version.tar.gz
Source2: %url/data/%_name-demosaic-pack-GPL3-%version.tar.gz

BuildRequires: gcc-c++ libjasper-devel liblcms2-devel libjpeg-devel libgomp-devel

%description
LibRaw is a library for reading RAW files from digital photo cameras
(CRW/CR2, NEF, RAF, DNG, MOS, KDC, DCR, etc.; virtually all RAW formats
are supported). It pays special attention to correct retrieval of data
required for subsequent RAW conversion.
This package contains shared library.

%package samples
Group: Graphics
Summary: sample tools based on the libraw
Requires: %name = %version-%release

%description samples
LibRaw is a library for reading RAW files from digital photo cameras
(CRW/CR2, NEF, RAF, DNG, MOS, KDC, DCR, etc.; virtually all RAW formats
are supported). It pays special attention to correct retrieval of data
required for subsequent RAW conversion.
This package contains samples binaries.

%package devel
Group: Development/C
Summary: library for reading RAW files
Requires: %name = %version-%release

%description devel
LibRaw is a library for reading RAW files from digital photo cameras
(CRW/CR2, NEF, RAF, DNG, MOS, KDC, DCR, etc.; virtually all RAW formats
are supported). It pays special attention to correct retrieval of data
required for subsequent RAW conversion.
This package contains library headers.

%package devel-static
Group: Development/C
Summary: static library for reading RAW files
Requires: %name-devel = %version-%release

%description devel-static
LibRaw is a library for reading RAW files from digital photo cameras
(CRW/CR2, NEF, RAF, DNG, MOS, KDC, DCR, etc.; virtually all RAW formats
are supported). It pays special attention to correct retrieval of data
required for subsequent RAW conversion.
This package contains static library.

%prep
%setup -n %_name-%version -a1 -a2

%build
%autoreconf
%configure --docdir=%_datadir/doc/libraw-%version --enable-jasper --enable-lcms

%install
%makeinstall_std

%files
%_libdir/libraw.so.*
%_libdir/libraw_r.so.*
%_datadir/doc/libraw-%version

%files samples
%_bindir/*

%files devel
%_includedir/libraw
%_libdir/libraw.so
%_libdir/libraw_r.so
%_libdir/pkgconfig/libraw.pc
%_libdir/pkgconfig/libraw_r.pc

%files devel-static
%_libdir/libraw.a
%_libdir/libraw_r.a

%changelog
