%define oname shapelib
Name: libshape
Version: 1.3.0b2
Release: alt1.qa1

Summary: API in "C" for Shapefile handling

# No version of the LGPL is given.
License: LGPLv2+ or MIT

Url: http://shapelib.maptools.org/
Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://download.osgeo.org/shapelib/%oname-%version.tar

Patch: shapelib-1.3.0b1-Makefile.patch
Patch1: shapelib-1.3.0b2-Makefile2.patch
Patch2: shapelib-1.2.10-endian.patch
Patch3: shapelib-1.3.0b1-buildid.patch

Group: Development/C

# Automatically added by buildreq on Sat Nov 13 2010
BuildRequires: gcc-c++ libproj-devel

BuildRequires: libproj-devel >= 4.4.1

%package devel
Summary: Development files for shapelib
Group: Development/Other
Requires: %name = %version-%release

%description
The Shapefile C Library provides the ability to write
simple C programs for reading, writing and updating (to a
limited extent) ESRI Shapefiles, and the associated
attribute file (.dbf).

%description devel
This package contains libshp and the appropriate header files.

%prep
%setup -n %oname-%version
%patch0 -p1 -b .makefile
%patch1 -p1 -b .makefile2
%patch2 -p1 -b .endian
%patch3 -p1 -b .buildid
%__subst "s/\r//g" README
chmod -x README

%build
%make_build libdir=%_libdir CFLAGS="$RPM_OPT_FLAGS" lib
%make_build libdir=%_libdir CFLAGS="$RPM_OPT_FLAGS" all

cd contrib
%make_build libdir=%_libdir EXTRACFLAGS="$RPM_OPT_FLAGS"

%install
%makeinstall
rm -f %buildroot/%_libdir/libshp.a

cd contrib
%makeinstall

%files
%_bindir/*
%_libdir/*.so.*

%doc LICENSE.LGPL README README.tree web/*.html
%doc contrib/doc/shpproj.txt stream1.sh stream1.out stream2.sh
%doc stream2.out makeshape.sh stream3.out ChangeLog

%files devel
%doc LICENSE.LGPL README
%_includedir/libshp/
%_libdir/*.so

%changelog
