%def_without static

Name: libshout
Version: 1.0.9
Release: alt5.qa1

Summary: libshout - icecast source streaming library
Group: System/Libraries
License: %lgpl2only

Url: http://www.icecast.org
Packager: Nikolay A. Fetisov <naf@altlinux.ru>

Source: ftp://ftp.icecast.org/pub/libshout/%name-%version.tar
Patch0: %name-1.0.9-alt-buffer_overflow.patch
Patch1: %name-1.0.9-alt-types.patch

BuildRequires(pre): rpm-build-licenses

%description
Libshout is a library for communicating with and sending data to an
icecast server. It handles the socket connection, the timing of the
data, and prevents most bad data from getting to the icecast server.

%package devel
Summary: icecast source streaming library development package
Group: Development/C
Requires: %name = %version-%release

%description devel
The libshout-devel package contains the header files needed for developing
applications that send data to an icecast server. Install libshout-devel if
you want to develop applications using libshout.

%package devel-static
Summary: icecast static library
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains static version of libshout library. Install
libshout-devel-static if you want to develop applications statically linked
with libshout.

%prep
%setup -q
%patch0
%patch1

%build
%autoreconf
%def_enable Werror
%configure
%make_build

%install
%make_install DESTDIR=%buildroot install

%if_without static
rm -f -- %buildroot%_libdir/*.a
%endif

rm -rf -- %buildroot%_prefix/doc


%files
%_libdir/*.so.*
%doc AUTHORS CHANGES README

%files devel
%_includedir/*
%_libdir/*.so
%doc doc/{*.html,*.css} example

%if_with static
%files devel-static
%_libdir/*.a
%endif

%changelog
