Name: libsndfile
Version: 1.0.28
Release: alt1.M80P.1

Summary: A library to handle various audio file formats
Group: System/Libraries
License: LGPL
Url: http://www.mega-nerd.com/%name/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %url/files/%name-%version.tar.gz

Patch0: libsndfile-1.0.25-system-gsm.patch
Patch1: libsndfile-1.0.25-zerodivfix.patch
Patch2: revert.patch
Patch3: libsndfile-1.0.28-flacbufovfl.patch
Patch4: libsndfile-1.0.29-cve2017_6892.patch
Patch5: libsndfile-1.0.28-cve2017_12562.patch

BuildRequires: gcc-c++ libalsa-devel libflac-devel libsqlite3-devel libvorbis-devel libgsm-devel
# for check
BuildRequires: python-modules

%description
%name is a C library for reading and writing sound files such as
AIFF, AU and WAV files through one standard interface. It can currently
read/write 8, 16, 24 and 32-bit PCM files as well as 32-bit floating
point WAV files and a number of compressed formats.

This package contains shared library required for %name-based applications.

%package devel
Summary: Development environment for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files required
in development of the %name-based applications.

%package utils
Summary: Utilities for %name
Group: Sound
Requires: %name = %version-%release

%description utils
This package contains utilities for %name

%prep
%setup -q
%patch0 -p1 -b .systemgsm
%patch1 -p1 -b .zerodivfix
%patch2 -p1 -b .revert
%patch3 -p1 -b .flacbufovfl
%patch4 -p1 -b .cve2017_6892
%patch5 -p1 -b .cve2017_12562
rm -r src/GSM610

%build
%autoreconf
%configure \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot \
      htmldir=%_docdir/%name-devel-%version/html install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%make check

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%doc %_docdir/%name-devel-%version
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files utils
%_bindir/*
%_man1dir/*.1*

%changelog
