
%def_disable gcrypt

Name: libssh
Version: 0.8.8
Release: alt1

Group: System/Libraries
Summary: C library to authenticate in a simple manner to one or more SSH servers
Url: http://www.libssh.org/
License: LGPL

# svn checkout svn://svn.berlios.de/libssh/trunk libssh
Source: http://www.libssh.org/files/%name-%version.tar.gz
Source1: version-script.libssh
Source2: compat.lds
Patch1: version-script.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires: cmake doxygen graphviz
BuildRequires: gcc-c++ %{?_enable_gcrypt: libgcrypt-devel}
BuildRequires: libssl-devel zlib-devel kde-common-devel
BuildRequires: libkrb5-devel

%description
The ssh library was designed to be used by programmers needing a working
SSH implementation by the mean of a library. The complete control of the
client is made by the programmer. With libssh, you can remotely execute
programs, transfer files, use a secure and transparent tunnel for your
remote programs. With its Secure FTP implementation, you can play with
remote files easily, without third-party programs others than libcrypto
(from openssl). libssh features :

    * Full C library functions for manipulating a client-side SSH
      connection
    * Lesser GPL licensing -SSH2 protocol compliant
    * Fully configurable sessions
    * Support for AES-128,AES-192,AES-256,blowfish, in cbc mode
    * Use multiple SSH connections in a same process, at same time
    * Use multiple channels in the same connection
    * Thread safety when using different sessions at same time
    * Basic but correct SFTP implementation (secure file transfer)
    * RSA and DSS server public key supported
    * Compression support (with zlib)
    * Public key (RSA and DSS), password and keyboard-interactive
      authentication
    * Complete documentation about its API
    * Runs and tested under amd64, x86, arm, sparc32, ppc under Linux,
      BSD, MacosX and Solaris
    * A developer listening to you
    * It's free (LGPL)!


%package devel
Summary: Development files for %name
Group: System/Libraries
Requires: %name = %version-%release
Provides: ssh-devel = %version-%release
%description devel
This package contains the development files for %name.


%prep
%setup -q
%patch1 -p1
install -m 0644 %SOURCE1 ./
install -m 0644 %SOURCE2 ./

%build
%Kbuild \
    -DWITH_ZLIB=ON \
    -DWITH_GSSAPI=ON \
    -DWITH_GCRYPT=%{?_enable_gcrypt:ON}%{!?_enable_gcrypt:OFF} \
    #

%install
%Kinstall

%files
%_libdir/libssh.so.4
%_libdir/libssh.so.*

%files devel
%_pkgconfigdir/%name.pc
%_libdir/cmake/libssh*
%_includedir/%name
%_libdir/*.so

%changelog
