Name: libssh2
Version: 1.4.3
Release: alt3.M80P.1

Summary: A library implementing the SSH2 protocol
Group: Networking/Remote access
License: BSD
Packager: Slava Dubrovskiy <dubrsl@altlinux.ru>
Url: http://www.libssh2.org/
# http://downloads.sourceforge.net/%name/%name-%version.tar.gz
Source: %name-%version.tar
BuildRequires: openssl-devel zlib-devel man

Patch1:  CVE-2015-1782.patch
Patch2:  0004-CVE-2016-0787.patch
Patch3:  CVE-2019-3855.patch
Patch4:  CVE-2019-3856.patch
Patch5:  CVE-2019-3857+3863-pre1.patch
Patch6:  CVE-2019-3857.patch
Patch7:  CVE-2019-3858.patch
Patch8:  CVE-2019-3862.patch
Patch9:  CVE-2019-3863.patch
Patch10: CVE-2019-3859-pre1.patch
Patch11: CVE-2019-3859-pre2.patch
Patch12: CVE-2019-3859-pre3.patch
Patch13: CVE-2019-3859-1.patch
Patch14: CVE-2019-3859-2.patch
Patch15: CVE-2019-3860.patch
Patch16: CVE-2019-3861.patch


%description
libssh2 is a library implementing the SSH2 protocol as defined by
Internet Drafts: SECSH-TRANS(22), SECSH-USERAUTH(25),
SECSH-CONNECTION(23), SECSH-ARCH(20), SECSH-FILEXFER(06)*,
SECSH-DHGEX(04), and SECSH-NUMBERS(10).

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package docs
Summary: Documentation for %name
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description docs
This package contains manual pages and examples for
developing applications that use %name.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1

%build
#autoreconf
./buildconf
%configure --disable-static --enable-shared
mkdir docdir
cp -al AUTHORS COPYING HACKING README NEWS example docdir/
%make_build

%install
%makeinstall_std
%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
cp -a docdir/* %buildroot%docdir/

%check
%make_build -k check

%files
%dir %docdir/
%docdir/[ACNR]*
%_libdir/*.so.*

%files docs
%dir %docdir/
%docdir/[He]*
%_mandir/man?/*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
