%define _unpackaged_files_terminate_build 1

%def_with check
%def_with python3

Name: libtdb
Version: 1.3.16
Release: alt2

Summary: A trivial database system
License: GPL
Group: System/Libraries
Url: http://tdb.samba.org/

Source: http://samba.org/ftp/tdb/tdb-%{version}.tar.gz
Patch: tdb-alt-fix-python-ldflags.patch

BuildRequires: docbook-dtds docbook-style-xsl xsltproc
BuildRequires: rpm-build-python python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif

%description
This is a simple database API. It was inspired by the realisation that
in Samba we have several ad-hoc bits of code that essentially
implement small databases for sharing structures between parts of
Samba. As I was about to add another I realised that a generic
database module was called for to replace all the ad-hoc bits.

I based the interface on gdbm. I couldn't use gdbm as we need to be
able to have multiple writers to the databases at one time.

(I == tridge@samba.org)

This is the primary library.

%package -n tdb-utils
Summary: a trivial database system utils
Group: Databases
Requires: %name = %version-%release

%description -n tdb-utils
This is a simple database API. It was inspired by the realisation that
in Samba we have several ad-hoc bits of code that essentially
implement small databases for sharing structures between parts of
Samba. As I was about to add another I realised that a generic
database module was called for to replace all the ad-hoc bits.

I based the interface on gdbm. I couldn't use gdbm as we need to be
able to have multiple writers to the databases at one time.

(I == tridge@samba.org)

This package contains some utils for managing tdb databases

%package devel
Summary: a trivial database system development files
Group: Development/C
Requires: %name = %version-%release

%description devel
This is a simple database API. It was inspired by the realisation that
in Samba we have several ad-hoc bits of code that essentially
implement small databases for sharing structures between parts of
Samba. As I was about to add another I realised that a generic
database module was called for to replace all the ad-hoc bits.

I based the interface on gdbm. I couldn't use gdbm as we need to be
able to have multiple writers to the databases at one time.

(I == tridge@samba.org)

These are the development files.

%package -n python-module-tdb
Group: Development/Python
Summary: Python bindings for the Tdb library
Requires: %name = %version-%release

%description -n python-module-tdb
Python bindings for libtdb

%if_with python3
%package -n python3-module-tdb
Group: Development/Python3
Summary: Python3 bindings for the Tdb library
Requires: %name = %EVR

%description -n python3-module-tdb
Python3 bindings for libtdb
%endif

%prep
%setup -n tdb-%version
%patch -p1

%build
%undefine _configure_gettext
%configure \
           --disable-rpath \
%if_with python3
	   --extra-python=python3 \
%endif
           --bundled-libraries=NONE \
	   --builtin-libraries=replace

%make_build

%install
%makeinstall_std

rm -f %buildroot%_libdir/libtdb.a

%check
make test

%files
%_libdir/libtdb.so.*
%doc docs/README

%files -n tdb-utils
%_bindir/*
%_man8dir/*

%files devel
%_libdir/libtdb.so
%_includedir/tdb.h
%_pkgconfigdir/tdb.pc

%files -n python-module-tdb
%python_sitelibdir/tdb.so
%python_sitelibdir/_tdb_text.py*

%if_with python3
%files -n python3-module-tdb
%python3_sitelibdir/tdb.cpython-*.so
%python3_sitelibdir/_tdb_text.py*
%python3_sitelibdir/__pycache__/_tdb_text.cpython*.py*
%endif

%changelog
