%define _unpackaged_files_terminate_build 1
%def_with check
%def_with python3

Name: libtevent
Version: 0.9.37
Release: alt2
Summary: The tevent library
License: LGPLv3+
Group: System/Libraries
Url: http://tevent.samba.org/

Source: http://samba.org/ftp/tevent/tevent-%{version}.tar.gz
Patch: tevent-alt-fix-python-ldflags.patch

BuildRequires: libtalloc-devel >= 2.1.14
BuildRequires: python-module-talloc-devel >= 2.1.14
BuildRequires: python-devel zlib-devel

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-talloc-devel
%endif

Requires: libtalloc >= 2.1.14

%description
Tevent is an event system based on the talloc memory management library.
Tevent has support for many event types, including timers, signals, and
the classic file descriptor events.
Tevent also provide helpers to deal with asynchronous code providing the
tevent_req (Tevent Request) functions.

%package devel
Group: Development/C
Summary: Developer tools for the Tevent library
Requires: %name = %version-%release

%description devel
Header files needed to develop programs that link against the tevent library.

%package -n python-module-tevent
Group: Development/Python
Summary: Python bindings for the Tevent library
Requires: %name = %version-%release

%description -n python-module-tevent
Python bindings for libtevent

%if_with python3
%package -n python3-module-tevent
Group: Development/Python3
Summary: Python3 bindings for the Tevent library
Requires: %name = %EVR

%description -n python3-module-tevent
Python3 bindings for libtevent
%endif

%prep
%setup -n tevent-%version
%patch -p1

%build
%undefine _configure_gettext
%configure \
	--disable-rpath \
	--bundled-libraries=NONE \
%if_with python3
        --extra-python=python3 \
%endif
	--builtin-libraries=replace

%make_build

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.a

%check
make test

%files
%_libdir/libtevent.so.*

%files devel
%_includedir/tevent.h
%_libdir/libtevent.so
%_pkgconfigdir/tevent.pc

%files -n python-module-tevent
%python_sitelibdir/_tevent.so
%python_sitelibdir/tevent.py*

%if_with python3
%files -n python3-module-tevent
%python3_sitelibdir/_tevent.cpython*.so
%python3_sitelibdir/tevent.py
%python3_sitelibdir/__pycache__/tevent.*
%endif

%changelog
