%define ltversion 1.4
%define libtool libtool-%ltversion
%define libltdl libltdl
%define priority 140

Name: libtool_%ltversion
Version: 1.4.3
Release: alt12
Epoch: 3

Summary: The GNU libtool, which simplifies the use of shared libraries
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/libtool/libtool.html

%add_findreq_skiplist %_datadir/%libtool/config.guess-%ltversion
%set_compress_method xz
%set_libtool_version 1.5
%set_automake_version 1.4
%set_autoconf_version 2.13

Provides: libtool = %epoch:%version-%release
PreReq: libtool-common, alternatives >= 0.4
Requires: %libltdl >= %epoch:%version-%release
Requires: aclocal(libtool)
Obsoletes: libtool < %epoch:%version

Source: ftp://ftp.gnu.org/gnu/libtool/libtool-1.4.3.tar
Source1: %name-buildreq.ignore

# RedHat patches
Patch1: libtool-1.3.5-rh-tmp.patch
Patch2: libtool-1.4-rh-ltmain-nonneg.patch
Patch3: libtool-1.4.3-rh-ltmain-SED.patch
Patch6: libtool-1.4.2-rh-relink-58664.patch
Patch9: libtool-1.4.2-rh-multilib.patch
Patch10: libtool-1.4.2-rh-demo.patch
# Patch from James Henstridge making restricted symbol exports work on Linux
Patch11: libtool-1.5-jh-expsym-linux.patch
# http://mail.gnu.org/pipermail/bug-libtool/2002-October/004272.html
Patch12: libtool-1.4.3-rh-readonlysym.patch
# Fix automake related test failure
#Patch14: libtool-1.5-rh-testfailure.patch
Patch17: libtool-1.4.3-rh-nostdlib.patch

# ALT patches
Patch20: libtool-1.5-alt-sys_lib_dlsearch.patch
Patch21: libtool-1.4.2-alt-ltmain-cpp-linkage.patch
Patch22: libtool-1.5-alt-texinfo.patch
Patch23: libtool-1.5-alt-makefile.patch
Patch24: libtool-1.5-alt-libtoolize-libtool.m4.patch

# Automatically added by buildreq on Tue Aug 19 2003
BuildRequires: gcc-c++ gcc-g77 libstdc++-devel makeinfo

%description
The libtool package contains the GNU libtool, a set of shell scripts
which automatically configure UNIX and UNIX-like architectures to
generically build shared libraries.  Libtool provides a consistent,
portable interface which simplifies the process of using shared
libraries.

If you are developing programs which will use shared libraries, you
should install libtool.

%prep
%setup -q -n libtool-%version

# RedHat patches
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch6 -p1
%patch9 -p1
%patch10 -p1
#patch11 -p1
%patch12 -p1
# backup suffix undesirable here
#patch14 -p1
#patch17 -p1

# ALT patches
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1

# Hack in the version-specific package data dir and aclocal dir variables.
perl -pi -e 's|^(pkgdatadir=.*?)\s*$|$1-%ltversion\n|;' configure.in

cp -p /usr/share/libtool/config/config.* .

rm doc/*.info*

bzip2 -9k ChangeLog*

find -type f -print0 |
	xargs -r0 grep -Zl '^# Libtool was configured' -- |
	xargs -r0 sed -i 's/^\(# Libtool was configured\).*/\1 as follows:/' --

%build
export CC=gcc
export CXX=g++
export F77=g77
export GCJ=gcj
for f in {,*/}acinclude.m4; do
	cp -p libtool.m4 "$f"
done
%undefine __libtoolize
%__aclocal
# new gettext introduce new m4 macros which depend on fresh autoconf
# and automake; hopefully libtool doesn't use gettext and its m4 macros.
%__subst -p 's,^AC_PREREQ(\[\?2\.5[0-9]\]\?),AC_PREREQ(2.13),' *.m4
%__autoheader
%__automake
%__autoconf
touch aclocal.m4
for f in */aclocal.m4; do
	cp aclocal.m4 "$f"
done

%configure --program-suffix=-%ltversion

perl -pi -e '/^\@direntry/../^\@end direntry/ and s/^\*\s*(libtool(ize)?):\s*\(libtool\)/* $1-%ltversion: (%libtool)/i' doc/libtool.texi

# SMP-incompatible build.
%make MAKEINFOFLAGS=--no-split

%check
make -k check ||:

%install
%makeinstall

mv %buildroot%_datadir/libtool/* \
      %buildroot%_datadir/%libtool/

mkdir %buildroot%_datadir/%libtool/aclocal
mv %buildroot%_datadir/aclocal/libtool.m4 \
    %buildroot%_datadir/%libtool/aclocal/

for f in ltmain.sh config.{guess,sub}; do
    rm -f %buildroot%_datadir/%libtool/$f
    ln -s $f-%ltversion %buildroot%_datadir/%libtool/$f
done
#for f in install-sh missing mkinstalldirs; do
#    mv %buildroot%_datadir/%libtool/$f{,-%ltversion}
#    ln -s $f-%ltversion %buildroot%_datadir/%libtool/$f
#done
#rm -f %buildroot%_datadir/libtool/libltdl/stamp-h.in

mv %buildroot%_infodir/libtool{,-%ltversion}.info

mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/libtool-default	%_bindir/%libtool	%priority
%_bindir/libtoolize-default	%_bindir/libtoolize-%ltversion	%_bindir/%libtool
%_datadir/libtool	%_datadir/%libtool	%_bindir/%libtool
%_infodir/libtool.info.xz	%_infodir/%libtool.info.xz	%_bindir/%libtool
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo libtool >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
install -p -m644 %SOURCE1 \
    %buildroot%_sysconfdir/buildreqs/files/ignore.d/%name

%define ltdocdir %_docdir/libtool-%version
%define ltdldocdir %_docdir/libltdl-%version

rln()
{
	local target=$1 && shift
	local source=$1 && shift
	target=`relative "$target" "$source"`
	ln -snf "$target" "%buildroot$source"
}

mkdir -p %buildroot%ltdocdir
install -p -m644 AUTHORS NEWS README THANKS TODO ChangeLog*.bz2 \
    %buildroot%ltdocdir/
rln %_licensedir/GPL-2 %ltdocdir/COPYING
mkdir -p %buildroot%ltdldocdir
install -p -m644 libltdl/README %buildroot%ltdldocdir/
rm -f %buildroot%_datadir/%libtool/libltdl/COPYING.LIB
rln %_licensedir/LGPL-2.1 %_datadir/%libtool/libltdl/COPYING.LIB
rln %_licensedir/LGPL-2.1 %ltdldocdir/COPYING.LIB

%files
%_bindir/*
%_datadir/%libtool
%_infodir/%libtool.info*
%_altdir/%name
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/%name
%dir %ltdocdir
%ltdocdir/[A-Z]*

%changelog
