%def_disable debug
%def_disable static
%if_disabled debug
%remove_optflags -O2
%add_optflags -O3
%endif
%define abiversion 9

Name: libtorrent-rasterbar%{abiversion}
Version: 1.1.4
Release: alt0.M80P.1

Summary: libTorrent is a BitTorrent library written in C++ for *nix
Group: System/Libraries
License: GPL
Url: http://www.rasterbar.com/products/libtorrent
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildRequires: boost-asio-devel boost-python-devel gcc-c++ libssl-devel

%description
libTorrent is designed to avoid redundant copying and storing of data
that other clients and libraries suffer from. libTorrent features:

* The client has full control over the polling of sockets.
* Sigc++ signals makes it easy for the client to react to events.
* Fast resume which checks the file modification time.
* Direct reading and writing from network to mmap'ed files.
* File hash check uses the same thread; client can control the rate;
  non-blocking and preload to memory with the mincore and madvise.
* File handler: fine-grained use of file read/write permissions, allows
  seeding of read-only files; allows torrents with unlimited number of
  files; opens closed files when mapping chunks to memory, with graceful
  error handling; support for files larger than 2 GB; different download
  priorities for files in the torrent.
* Multi-tracker support.
* No dependency on any specific HTTP library, the client implements a
  wrapper class.
* Dynamic request pipe size.
* Upload and download throttle.
* And much more...

%package -n %name-devel
Summary: Development libraries and header files for libTorrent
Group: Development/C++
Requires: %name = %version-%release
Conflicts: libtorrent-rasterbar-devel
Conflicts: libtorrent-devel

%description -n %name-devel
The libtorrent-devel package contains libraries and header files needed
to develop applications using libTorrent.

%if_enabled static
%package -n %name-devel-static
Summary: Development static libraries for libTorrent
Group: Development/C++
Requires: %name = %version-%release
Conflicts: libtorrent-rasterbar-devel-static
Conflicts: libtorrent-devel-static

%description -n %name-devel-static
The libtorrent-devel package contains static libraries needed
to develop applications using libTorrent.
%endif

%package -n python-module-%name
Summary: libTorrent python bindings
Group: Development/Python
Requires: %name = %version-%release

%description -n python-module-%name
The python-module-libtorrent-rasterbar contains
python bindings to libTorrent.

%prep
%setup
mkdir -p build-aux
touch build-aux/config.rpath

%build
export CFLAGS="%optflags -fno-strict-aliasing"
export CXXFLAGS="$CXXFLAGS -std=c++11"
%ifarch aarch64
# Some architectures require explicit linkage to libboost_atomic on boost 1.55 and older.
export LIBS="$LIBS -lboost_atomic"
%endif
%autoreconf
%configure \
		--disable-static \
		--disable-silent-rules \
		--enable-tests \
		--enable-examples \
		--enable-python-binding
%make_build V=1

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.la
%if_disabled static
rm -f %buildroot%_libdir/*.a
%endif

%files
%doc AUTHORS ChangeLog NEWS README.rst
%doc --no-dereference COPYING
%_libdir/*.so.*

%files -n %name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%endif

%files -n python-module-%name
%python_sitelibdir/libtorrent.so
%python_sitelibdir/*.egg-info

%changelog
