%define _name totem-pl-parser
%define ver_major 3.10
%define _libexecdir %_prefix/libexec
%def_enable gtk_doc
%def_enable introspection
%def_enable libgcrypt
%def_enable quvi

Name: lib%_name
Version: %ver_major.8
Release: alt0.M80P.1

Summary: Shared libraries of the Totem media player play list parser
Group: System/Libraries
License: GPL
URL: http://www.hadess.net/%_name.php3

#Source: %_name-%version.tar
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

%define glib_ver 2.34
%define soup_ver 2.43
%define quvi_ver 0.9.1
%define archive_ver 3.0

BuildPreReq: gnome-common gtk-doc intltool libgio-devel >= %glib_ver
BuildPreReq: libarchive-devel >= %archive_ver libsoup-gnome-devel >= %soup_ver
BuildRequires: libgmime3.0-devel libxml2-devel
%{?_enable_libgcrypt:BuildRequires: libgcrypt-devel}
%{?_enable_quvi:BuildRequires: libquvi0.9-devel >= %quvi_ver}
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.9.5}

%description
Shared libraries that come with the Totem media player.

%package devel
Summary: Development files for Totem media player play list parser
Group: Development/C
Requires: %name = %version-%release

%description devel
Totem is simple movie player for the Gnome desktop based on Xine.
This package provides files needed to build applications using Totem
libraries.

%package devel-doc
Summary: Development documentation for Totem media player play list parser
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
Totem is simple movie player for the Gnome desktop based on Xine.
This package contains documentation needed to develop applications using Totem
libraries.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Totem playlist parser library

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Totem playlist parser library


%prep
%setup -n %_name-%version
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
	--disable-static \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable introspection} \
	%{subst_enable libgcrypt} \
	%{subst_enable quvi}
%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang %_name %_name-2.0

%files -f %name.lang
%_libdir/*.so.*
%if_enabled quvi
%dir %_libexecdir/%_name
%_libexecdir/%_name/99-%_name-videosite
%endif
%doc AUTHORS NEWS README

%files -n %name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files -n %name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/*

%files gir-devel
%_datadir/gir-1.0/*
%endif

%changelog
