Name: libupnp
Version: 1.6.19
Release: alt2

Summary: Linux SDK for UPnP Devices
License: BSD
Group: System/Libraries
Url: http://upnp.sourceforge.net/

Source: %name-%version-%release.tar

%description
The Linux SDK for UPnP Devices (libupnp) provides developers with an API
and open source code for building control points, devices, and bridges that
are compliant with Version 1.0 of the Universal Plug and Play Device
Architecture Specification.

UPnP is an architecture that enables discovery, event notification, and
control of devices on a network, independent of operating system, programming
language, or physical network connection. UPnP is based on common Internet
standards and specifications such as TCP/IP, HTTP, and XML. For detailed
information about UPnP, including the UPnP Device Architecture Specification,
please visit the UPnP Forum web site.

%package -n libixml2
Summary: Complementary library for Linux SDK for UPnP Devices
Group: System/Libraries
Conflicts: libupnp < 1.6.7

%package -n libupnp6
Summary: Linux SDK for UPnP Devices
Group: System/Libraries
Requires: libixml2 = %version-%release

%package devel
Summary: Development libraries and header files for libupnp
Group: Development/C
Requires: libupnp6 = %version-%release
Requires: libixml2 = %version-%release

%description -n libixml2
The Linux SDK for UPnP Devices (libupnp) provides developers with an API
and open source code for building control points, devices, and bridges that
are compliant with Version 1.0 of the Universal Plug and Play Device
Architecture Specification.

%description -n libupnp6
The Linux SDK for UPnP Devices (libupnp) provides developers with an API
and open source code for building control points, devices, and bridges that
are compliant with Version 1.0 of the Universal Plug and Play Device
Architecture Specification.

%description devel
The libupnp-devel package contains libraries and header files needed
to develop applications using libupnp.

%prep
%setup

%build
%autoreconf
%configure --enable-ipv6 --disable-static
%make_build

%install
%make_install DESTDIR=%buildroot install

%files -n libixml2
%_libdir/libixml.so.*

%files -n libupnp6
%doc ChangeLog LICENSE NEWS README TODO
%_libdir/libthreadutil.so.*
%_libdir/libupnp.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%changelog
