# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%def_disable test
%def_with doc

%define oname uriparser
Name: liburiparser
Version: 0.9.0
Release: alt0.M80P.1

Summary: A strictly RFC 3986 compliant URI parsing library

License: BSD
Group: System/Libraries
Url: https://uriparser.github.io/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/uriparser/uriparser/archive/uriparser-%version.tar.gz
Source: %name-%version.tar

BuildRequires: gcc-c++ libcpptest-devel doxygen graphviz

%if_with doc
# uses qhelpgenerator-qt5 for doc
BuildRequires: qt5-tools
%endif

%if_enabled test
BuildRequires: libgtest-devel >= 1.9.1
%endif

%description
uriparser is a strictly RFC 3986 compliant URI parsing library.
uriparser is cross-platform, fast, supports Unicode.

%package devel
Summary: Header files for uriparser
Group: Development/Other
Requires: %name = %version-%release

%description devel
Header files for uriparser.

%prep
%setup
%__subst "s|qhelpgenerator|qhelpgenerator-qt5|g" configure*

%build
%autoreconf
%configure --disable-static \
           %{subst_enable test}
%make_build

%install
touch doc/html/FIXME.map
%makeinstall_std

%files
%doc AUTHORS ChangeLog
%_bindir/uriparse
%_libdir/lib*.so.*

%files devel
%_docdir/%oname/
%_libdir/lib*.so
%_includedir/%oname/
%_pkgconfigdir/*

%changelog
