%define _name vigra
%def_disable static

Name: lib%_name
Version: 1.11.0
Release: alt1

Summary: Generic Programming for Computer Vision
License: MIT
Group: System/Libraries
Url: http://ukoethe.github.io/%_name

# VCS https://github.com/ukoethe/%name/
Source: https://github.com/ukoethe/%_name/releases/download/Version-1-11-0/%_name-%version-src.tar.gz
# partially deimproved FindOpenEXR
Patch: vigra-1.11.0-alt-findexr.patch

# Automatically added by buildreq on Wed Jun 13 2007
BuildRequires: gcc-c++ cmake libfftw3-devel libjpeg-devel libpng-devel libtiff-devel
BuildRequires: libhdf5-devel libgomp-devel openexr-devel doxygen

Provides: %_name
Obsoletes: %_name

%description
VIGRA stands for "Vision with Generic Algorithms". It's a novel
computer vision library that puts its main emphasize on customizable
algorithms and data structures.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C
Requires: %name = %version-%release
Provides: %_name-devel
Obsoletes: %_name-devel

%description devel
This package contains the headers that programmers will need to develop
applications which will use %name.

%package devel-doc
Summary: Development documentation for vigra library
Group: Development/C++
Requires: %name-devel = %version-%release
Provides: %_name-devel-doc
Obsoletes: %_name-devel-doc
BuildArch: noarch

%description devel-doc
Development documentation for vigra library.

%prep
%setup -n %_name-%version
%patch

%build
%cmake -DWITH_VIGRANUMPY:BOOL=OFF \
	-DWITH_HDF5:BOOL=ON \
	-DWITH_OPENEXR:BOOL=ON \
	-DDOCINSTALL:STRING=share/doc
%cmake_build

%install
%cmakeinstall_std

%files
%_libdir/%{name}impex.so.*

%files devel
%_bindir/%_name-config
%_includedir/%_name/
%_libdir/*.so
%_libdir/%_name/

%files devel-doc
%_datadir/doc/%_name/

%exclude %_datadir/doc/%{_name}numpy


%changelog
