# -*- rpm-spec -*-

# %%branch_switch set %%branch_release use
#%%define branch_switch Mxx

%define _localstatedir /var
%define _libexecdir %_prefix/libexec
%define qemu_user  _libvirt
%define qemu_group  vmusers

# A client only build will create a libvirt.so only containing
# the generic RPC driver, and test driver and no libvirtd
# Default to a full server + client build

%ifarch %ix86 x86_64 ia64
%def_enable server_drivers
%else
%def_disable server_drivers
%endif

# Always build with dlopen'd modules
%def_with driver_modules

%if_enabled server_drivers
# First the daemon itself
%def_with libvirtd
%def_with avahi

# Then the hypervisor drivers that run on local host
%def_without xen
%def_with qemu
%def_with openvz
%def_with lxc
%def_with login_shell
%def_with vbox
%def_without uml
%def_without libxl
%def_with vmware

# Then the hypervisor drivers that talk via a native remote protocol
%def_with phyp
%def_with esx
%def_without hyperv
%def_without xenapi


# Then the secondary host drivers
%def_with network
%def_with storage_fs
%def_with storage_lvm
%def_with storage_scsi
%def_with storage_iscsi
%def_with storage_disk
%def_with storage_rbd
%def_with storage_mpath
%def_with storage_gluster
%def_with storage_zfs
%def_without storage_sheepdog
%def_without storage_vstorage
%def_with numactl
%def_with selinux

# A few optional bits
%def_without netcf
%def_with udev
%def_without hal
%def_with yajl
%def_with sanlock
%def_with fuse
%def_with pm_utils

%endif #server_drivers

%if_with  qemu
%def_with qemu_tcg

%ifarch %ix86 x86_64
%def_with qemu_kvm
%endif
%endif

# A few optional bits
%def_with dbus
%def_with polkit
%def_with capng
%def_with firewalld

%if_with qemu || lxc || uml
%def_with nwfilter
%def_with libpcap
%endif

%if_with qemu
%def_with macvtap
%def_with libnl
%endif

%def_with audit
%def_without dtrace

# Non-server/HV driver defaults which are always enabled
%def_with sasl
%def_with libssh

%def_without wireshark


Name: libvirt
Version: 3.10.0
Release: alt3
Summary: Library providing a simple API virtualization
License: LGPLv2+
Group: System/Libraries
Url: https://libvirt.org/
Source0: %name-%version.tar
Source1: gnulib-%name-%version.tar
Source2: keycodemapdb-%name-%version.tar
Patch1: %name-%version.patch


%{?_with_libvirtd:Requires: %name-daemon = %EVR}
%{?_with_network:Requires: %name-daemon-config-network = %EVR}
%{?_with_nwfilter:Requires: %name-daemon-config-nwfilter = %EVR}
%{?_with_qemu:Requires: %name-qemu-common = %EVR}
%{?_with_polkit:Requires: polkit}
Requires: %name-client = %EVR
Requires: %name-libs = %EVR

BuildRequires(pre): rpm-build-ubt
%{?_with_xen:BuildRequires: xen-devel xen-runtime}
%{?_with_libxl:BuildRequires: xen-devel}
%{?_with_hal:BuildRequires: libhal-devel}
%{?_with_udev:BuildRequires: libudev-devel libpciaccess-devel}
%{?_with_yajl:BuildRequires: libyajl-devel}
%{?_with_sanlock:BuildRequires: sanlock-devel >= 1.8}
%{?_with_libpcap:BuildRequires: libpcap-devel}
%{?_with_libnl:BuildRequires: libnl-devel}
%{?_with_avahi:BuildRequires: libavahi-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}
%{?_with_network:BuildRequires: dnsmasq iptables iptables-ipv6 radvd}
%{?_with_nwfilter:BuildRequires: ebtables}
%{?_with_sasl:BuildRequires: libsasl2-devel}
%{?_with_libssh:BuildRequires: pkgconfig(libssh) >= 0.7}
%{?_with_dbus:BuildRequires: libdbus-devel >= 1.0.0}
%{?_with_polkit:BuildRequires: polkit}
%{?_with_storage_fs:BuildRequires: util-linux}
%{?_with_qemu:BuildRequires: qemu-img}
%{?_with_storage_lvm:BuildRequires: lvm2}
%{?_with_storage_disk:BuildRequires: libparted-devel parted libuuid-devel dmsetup libdevmapper-devel}
%{?_with_storage_rbd:BuildRequires: ceph-devel}
%{?_with_storage_iscsi:BuildRequires: open-iscsi}
%{?_with_storage_mpath:BuildRequires: libdevmapper-devel}
%{?_with_storage_gluster:BuildRequires: glusterfs3-devel >= 3.4.1}
%{?_with_storage_zfs:BuildRequires: zfs-utils}
%{?_with_storage_vstorage:BuildRequires: /usr/sbin/vstorage}
%{?_with_numactl:BuildRequires: libnuma-devel}
%{?_with_capng:BuildRequires: libcap-ng-devel}
%{?_with_phyp:BuildRequires: libssh2-devel}
%{?_with_netcf:BuildRequires: netcf-devel}
%{?_with_esx:BuildRequires: libcurl-devel}
%{?_with_hyperv:BuildRequires: libwsman-devel}
%{?_with_audit:BuildRequires: libaudit-devel}
%{?_with_fuse:BuildRequires: libfuse-devel >= 2.8.6}
%{?_with_pm_utils:BuildRequires: pm-utils}
%{?_with_wireshark:BuildRequires: glib2-devel wireshark tshark wireshark-devel >= 2.1.0}

BuildRequires: bridge-utils libblkid-devel
BuildRequires: libgcrypt-devel libgnutls-devel >= 2.2.0 libp11-kit-devel
BuildRequires: libreadline-devel
BuildRequires: libtasn1-devel
BuildRequires: libattr-devel attr
BuildRequires: libacl-devel
BuildRequires: perl-Pod-Parser perl-XML-XPath
BuildRequires: libxml2-devel xml-utils xsltproc xhtml1-dtds
BuildRequires: python python-devel
BuildRequires: zlib-devel
BuildRequires: iproute2 perl-Pod-Parser
BuildRequires: dmidecode
BuildRequires: /sbin/rmmod

%description
Libvirt is a C toolkit to interact with the virtualization capabilities
of recent versions of Linux (and other OSes).
The main package includes the libvirtd server exporting the virtualization support.

%package docs
Summary: Documentation for libvirt library and daemon
Group: Development/Documentation
BuildArch: noarch

%description docs
Copy of the libvirt website documentation

%package daemon
Summary: Server side daemon and supporting files for libvirt library
Group: System/Servers
Requires: %name-libs = %EVR
Requires: iptables
%{?_with_pm_utils:Requires: pm-utils}
Requires: dmidecode
# libvirtd depends on 'messagebus' service
Requires: dbus

Conflicts: %name-daemon-config-network < %EVR
Conflicts: %name-daemon-config-nwfilter < %EVR
Conflicts: %name-daemon-driver-interface < %EVR
Conflicts: %name-daemon-driver-qemu < %EVR
Conflicts: %name-daemon-driver-nodedev < %EVR
Conflicts: %name-daemon-driver-secret < %EVR
Conflicts: %name-daemon-driver-storage < %EVR
Conflicts: %name-daemon-driver-vbox < %EVR
Conflicts: %name-daemon-driver-nwfilter < %EVR
Conflicts: %name-daemon-driver-lxc < %EVR
Conflicts: %name-daemon-driver-network < %EVR
Conflicts: %name-lock-sanlock < %EVR

%description daemon
Server side daemon required to manage the virtualization capabilities
of recent versions of Linux. Requires a hypervisor specific sub-RPM
for specific drivers.

%package daemon-config-network
Summary: Default configuration files for the libvirtd daemon
Group: System/Servers
BuildArch: noarch
Requires: bridge-utils
Requires: dnsmasq
%if_with driver_modules
Requires: %name-daemon-driver-network = %EVR
%endif

%description daemon-config-network
Default configuration files for setting up NAT based networking

%package daemon-config-nwfilter
Summary: Network filter configuration files for the libvirtd daemon
Group: System/Servers
BuildArch: noarch
%if_with driver_modules
Requires: %name-daemon-driver-nwfilter = %EVR
%endif

%description daemon-config-nwfilter
Network filter configuration files for cleaning guest traffic

%if_with driver_modules
%if_with network
%package daemon-driver-network
Summary: Network driver plugin for the libvirtd daemon
Group: System/Libraries

%description daemon-driver-network
The network driver plugin for the libvirtd daemon, providing
an implementation of the virtual network APIs using the Linux
bridge capabilities.
%endif

%if_with nwfilter
%package daemon-driver-nwfilter
Summary: Nwfilter driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: ebtables

%description daemon-driver-nwfilter
The nwfilter driver plugin for the libvirtd daemon, providing
an implementation of the firewall APIs using the ebtables,
iptables and ip6tables capabilities
%endif

%if_with udev
%package daemon-driver-nodedev
Summary: Nodedev driver plugin for the libvirtd daemon
Group: System/Libraries

%description daemon-driver-nodedev
The nodedev driver plugin for the libvirtd daemon, providing
an implementation of the node device APIs using the udev
capabilities.

%package daemon-driver-interface
Summary: Interface driver plugin for the libvirtd daemon
Group: System/Libraries

%description daemon-driver-interface
The interface driver plugin for the libvirtd daemon, providing
an implementation of the network interface APIs using the
netcf library or udev.
%endif

%package daemon-driver-secret
Summary: Secret driver plugin for the libvirtd daemon
Group: System/Libraries

%description daemon-driver-secret
The secret driver plugin for the libvirtd daemon, providing
an implementation of the secret key APIs.

%package daemon-driver-storage
Summary: Storage driver plugin including all backends for the libvirtd daemon
Group: System/Libraries
BuildArch: noarch
%if_with storage_fs
Requires: libvirt-daemon-driver-storage-fs = %EVR
%endif
%if_with storage_disk
Requires: libvirt-daemon-driver-storage-disk = %EVR
%endif
%if_with storage_lvm
Requires: libvirt-daemon-driver-storage-logical = %EVR
%endif
%if_with storage_scsi
Requires: libvirt-daemon-driver-storage-scsi = %EVR
%endif
%if_with storage_iscsi
Requires: libvirt-daemon-driver-storage-iscsi = %EVR
%endif
%if_with storage_mpath
Requires: libvirt-daemon-driver-storage-mpath = %EVR
%endif
%if_with storage_gluster
Requires: libvirt-daemon-driver-storage-gluster = %EVR
%endif
%if_with storage_rbd
Requires: libvirt-daemon-driver-storage-rbd = %EVR
%endif
%if_with storage_sheepdog
Requires: libvirt-daemon-driver-storage-sheepdog = %EVR
%endif
%if_with storage_zfs
Requires: libvirt-daemon-driver-storage-zfs = %EVR
%endif

%description daemon-driver-storage
The storage driver plugin for the libvirtd daemon, providing
an implementation of the storage APIs using files, local disks, LVM, SCSI,
iSCSI, and multipath storage.

%package daemon-driver-storage-core
Summary: Storage driver plugin including base backends for the libvirtd daemon
Group: System/Libraries
Conflicts: %name-daemon < %EVR

%description daemon-driver-storage-core
The storage driver plugin for the libvirtd daemon, providing
an implementation of the storage APIs.

%package daemon-driver-storage-fs
Summary: Storage driver plugin for fs
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR

%description daemon-driver-storage-fs
The storage driver backend adding implementation of the storage APIs for block
volumes using fs.

%package daemon-driver-storage-logical
Summary: Storage driver plugin for lvm volumes
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR
Requires: lvm2

%description daemon-driver-storage-logical
The storage driver backend adding implementation of the storage APIs for block
volumes using lvm.

%package daemon-driver-storage-disk
Summary: Storage driver plugin for disk
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR
Requires: parted
Requires: dmsetup

%description daemon-driver-storage-disk
The storage driver backend adding implementation of the storage APIs for block
volumes using the host disks.

%package daemon-driver-storage-scsi
Summary: Storage driver plugin for local scsi devices
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR

%description daemon-driver-storage-scsi
The storage driver backend adding implementation of the storage APIs for scsi
host devices.

%package daemon-driver-storage-iscsi
Summary: Storage driver plugin for iscsi
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR
Requires: iscsi-initiator-utils

%description daemon-driver-storage-iscsi
The storage driver backend adding implementation of the storage APIs for iscsi
volumes using the host iscsi stack.

%package daemon-driver-storage-mpath
Summary: Storage driver plugin for multipath volumes
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR
Requires: dmsetup
Requires: multipath-tools

%description daemon-driver-storage-mpath
The storage driver backend adding implementation of the storage APIs for
multipath storage using device mapper.

%package daemon-driver-storage-gluster
Summary: Storage driver plugin for gluster
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR
Requires: /usr/sbin/gluster

%description daemon-driver-storage-gluster
The storage driver backend adding implementation of the storage APIs for gluster
volumes using libgfapi.

%package daemon-driver-storage-rbd
Summary: Storage driver plugin for rbd
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR

%description daemon-driver-storage-rbd
The storage driver backend adding implementation of the storage APIs for rbd
volumes using the ceph protocol.

%package daemon-driver-storage-sheepdog
Summary: Storage driver plugin for sheepdog
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR
Requires: sheepdog

%description daemon-driver-storage-sheepdog
The storage driver backend adding implementation of the storage APIs for
sheepdog volumes using.

%package daemon-driver-storage-zfs
Summary: Storage driver plugin for zfs
Group: System/Libraries
Requires: libvirt-daemon-driver-storage-core = %EVR

%description daemon-driver-storage-zfs
The storage driver backend adding implementation of the storage APIs for
zfs volumes using.

%if_with qemu
%package daemon-driver-qemu
Summary: Qemu driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon-driver-network = %EVR
Requires: %name-daemon-driver-storage-fs = %EVR
Requires: /usr/bin/qemu-img
# For image compression
Requires: gzip
Requires: bzip2
Requires: xz

%description daemon-driver-qemu
The qemu driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
QEMU
%endif

%if_with lxc
%package daemon-driver-lxc
Summary: LXC driver plugin for the libvirtd daemon
Group: System/Libraries
Requires: %name-daemon-driver-network = %EVR

%description daemon-driver-lxc
The LXC driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
the Linux kernel
%endif

%if_with uml
%package daemon-driver-uml
Summary: Uml driver plugin for the libvirtd daemon
Group: System/Libraries

%description daemon-driver-uml
The UML driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
User Mode Linux
%endif

%if_with xen
%package daemon-driver-xen
Summary: Xen driver plugin for the libvirtd daemon
Group: System/Libraries

%description daemon-driver-xen
The Xen driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
Xen
%endif

%if_with libxl
%package daemon-driver-libxl
Summary: Libxl driver plugin for the libvirtd daemon
Group: System/Libraries

%description daemon-driver-libxl
The Libxl driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
Libxl
%endif

%if_with vbox
%package daemon-driver-vbox
Summary: VirtualBox driver plugin for the libvirtd daemon
Group: System/Libraries

%description daemon-driver-vbox
The vbox driver plugin for the libvirtd daemon, providing
an implementation of the hypervisor driver APIs using
VirtualBox
%endif

%endif #driver_modules

%package qemu-common
Summary: Server side daemon, driver & default configs required to run QEMU or KVM guests
Group: System/Servers
BuildArch: noarch
Requires: %name-daemon-config-network = %EVR
Requires: %name-daemon-driver-interface = %EVR
Requires: %name-daemon-config-nwfilter = %EVR
%if_with driver_modules
Requires: %name-daemon-driver-qemu = %EVR
Requires: %name-daemon-driver-nodedev = %EVR
Requires: %name-daemon-driver-secret = %EVR
Requires: %name-daemon-driver-storage-fs = %EVR
%endif

%description qemu-common
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of QEMU or KVM.

%package qemu
Summary: Server side daemon, driver & default configs required to run QEMU guests
Group: System/Servers
BuildArch: noarch
Requires: %name-qemu-common = %EVR
Requires: qemu

%description qemu
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of QEMU.

%package kvm
Summary: Server side daemon, driver & default configs required to run KVM guests
Group: System/Servers
BuildArch: noarch
Requires: %name-qemu-common = %EVR
Requires: qemu-kvm

%description kvm
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of KVM.

%package lxc
Summary: Server side daemon, driver & default configs required to run LXC guests
Group: System/Servers
Requires: %name-daemon-config-network = %EVR
Requires: %name-daemon-config-nwfilter = %EVR
Requires: lxc
%if_with driver_modules
Requires: %name-daemon-driver-lxc = %EVR
Requires: %name-daemon-driver-nodedev = %EVR
Requires: %name-daemon-driver-secret = %EVR
Requires: %name-daemon-driver-storage = %EVR
%endif

%description lxc
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of LXC.

%package uml
Summary: Server side daemon, driver & default configs required to run UML guests
Group: System/Servers
Requires: %name-daemon-config-network = %EVR
Requires: %name-daemon-config-nwfilter = %EVR
%if_with driver_modules
Requires: %name-daemon-driver-uml = %EVR
Requires: %name-daemon-driver-nodedev = %EVR
Requires: %name-daemon-driver-secret = %EVR
Requires: %name-daemon-driver-storage = %EVR
%endif

%description uml
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of UML.

%package xen
Summary: Server side daemon, driver & default configs required to run XEN guests
Group: System/Servers
BuildArch: noarch
Requires: %name-daemon-config-network = %EVR
Requires: %name-daemon-config-nwfilter = %EVR
Requires: xen
%if_with driver_modules
%if_with xen
Requires: %name-daemon-driver-xen = %EVR
%endif
%if_with libxl
Requires: %name-daemon-driver-libxl = %EVR
%endif
Requires: %name-daemon-driver-nodedev = %EVR
Requires: %name-daemon-driver-secret = %EVR
Requires: %name-daemon-driver-storage = %EVR
%endif #driver_modules

%description xen
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of Xen.

%package vbox
Summary: Server side daemon, driver & default configs required to run VirtualBox guests
Group: System/Servers
BuildArch: noarch
Requires: %name-daemon-config-network = %EVR
Requires: %name-daemon-config-nwfilter = %EVR
%if_with driver_modules
Requires: %name-daemon-driver-vbox = %EVR
Requires: %name-daemon-driver-nodedev = %EVR
Requires: %name-daemon-driver-secret = %EVR
Requires: %name-daemon-driver-storage = %EVR
%endif

%description vbox
Server side daemon, driver and default network & firewall configs
required to manage the virtualization capabilities of VirtualBox.

%package client
Summary: Client side utilities of the libvirt library
Group: System/Libraries
Requires: %name-libs = %EVR
# Needed by libvirt-guests init script.
Requires: gettext
# For virConnectGetSysinfo
Requires: dmidecode
# Needed by virt-pki-validate script
Requires: gnutls-utils
# Needed for probing the power management features of the host.
Conflicts: %name < 0.9.11

%description client
The client binaries needed to access the virtualization
capabilities of recent versions of Linux (and other OSes).

%package libs
Summary: Client side libraries
Group: System/Libraries
# So remote clients can access libvirt over SSH tunnel
# (client invokes 'nc' against the UNIX socket on the server)
Requires: nc
Requires: /etc/sasl2

%description libs
Shared libraries for accessing the libvirt daemon.

%package admin
Summary: Set of tools to control libvirt daemon
Group: System/Servers
Requires: %name-libs = %EVR

%description admin
The client side utilities to control the libvirt daemon.

%package -n wireshark-plugin-%name
Summary: Wireshark dissector plugin for libvirt RPC transactions
Group: Networking/Other
Requires: wireshark
Requires: %name-libs = %EVR

%description -n wireshark-plugin-%name
Wireshark dissector plugin for better analysis of libvirt RPC traffic.

%package login-shell
Summary: Login shell for connecting users to an LXC container
Group: System/Libraries
Requires: %name-libs = %EVR

%description login-shell
Provides the set-uid virt-login-shell binary that is used to
connect a user to an LXC container when they login, by switching
namespaces.

%package devel
Summary: Libraries, includes, etc. to compile with the libvirt library
Group: Development/C
Requires: %name-libs = %EVR

%description devel
Includes and documentations for the C library providing an API to use
the virtualization capabilities of recent versions of Linux (and other OSes).

%package lock-sanlock
Summary: Sanlock lock manager plugin for QEMU driver
Group: System/Libraries
PreReq: sanlock >= 2.4
#for virt-sanlock-cleanup require augeas
Requires: augeas
Requires: %name-libs = %EVR

%description lock-sanlock
Includes the Sanlock lock manager plugin for the QEMU
driver

%package -n nss-%name
Summary: Libvirt plugin for Name Service Switch
Group: System/Libraries
Requires: %name-daemon-driver-network = %EVR

%description -n nss-%name
Libvirt plugin for NSS for translating domain names into IP addresses.

%prep
%setup -a1
mkdir -p src/keycodemapdb
tar -xf %SOURCE2 -C src/keycodemapdb --strip-components 1

%patch1 -p1
# git and rsync aren't needed for build.
sed -i '/^\(git\|rsync\)[[:space:]]/d' bootstrap.conf
# disable virnetsockettest test
sed -i 's/virnetsockettest //' tests/Makefile.am
# disable vircgrouptest test
sed -i 's/vircgrouptest //' tests/Makefile.am

%build
LOADERS_OLD="%_datadir/OVMF/OVMF_CODE.fd:%_datadir/OVMF/OVMF_VARS.fd"
LOADERS_NEW="%_datadir/edk2/ovmf/OVMF_CODE.fd:%_datadir/edk2/ovmf/OVMF_VARS.fd:%_datadir/edk2/aarch64/QEMU_EFI-pflash.raw:%_datadir/edk2/aarch64/vars-template-pflash.raw"
LOADERS="$LOADERS_OLD:$LOADERS_NEW"
%define with_loader_nvram $LOADERS

./bootstrap --no-git --gnulib-srcdir=gnulib-%name-%version
%configure \
		--disable-static \
		--disable-rpath \
		--with-packager-version="%release" \
		--with-init-script=systemd+redhat \
		--with-qemu-user=%qemu_user \
		--with-qemu-group=%qemu_group \
		--with-xml-catalog-file=/etc/sgml/catalog \
		--with-sysctl=check \
		%{subst_with libvirtd} \
		%{subst_with avahi} \
		%{subst_with xen} \
		%{subst_with qemu} \
		%{subst_with openvz} \
		%{subst_with lxc} \
		%{?_with_login_shell:--with-login-shell} \
		%{subst_with vbox} \
		%{subst_with uml} \
		%{subst_with libxl} \
		%{subst_with vmware} \
		%{subst_with phyp} \
		%{subst_with esx} \
		%{subst_with hyperv} \
		%{subst_with xenapi} \
		%{subst_with network} \
		%{?_with_storage_fs:--with-storage-fs} \
		%{?_with_storage_lvm:--with-storage-lvm} \
		%{?_with_storage_iscsi:--with-storage-iscsi} \
		%{?_with_storage_scsi:--with-storage-scsi} \
		%{?_with_storage_disk:--with-storage-disk} \
		%{?_with_storage_rbd:--with-storage-rbd} \
		%{?_with_storage_mpath:--with-storage-mpath} \
		%{?_with_storage_gluster:--with-storage-gluster} \
		%{?_with_storage_zfs:--with-storage-zfs} \
		%{?_with_storage_vstorage:--with-storage-vstorage} \
		%{?_with_storage_sheepdog:--with-storage-sheepdog} \
		%{subst_with numactl} \
		%{subst_with selinux} \
		%{subst_with netcf} \
		%{subst_with udev} \
		%{subst_with hal} \
		%{subst_with yajl} \
		%{subst_with sanlock} \
		%{subst_with fuse} \
		%{subst_with dbus} \
		%{?_with_pm_utils:--with-pm-utils} \
		%{subst_with polkit} \
		%{subst_with firewalld} \
		%{subst_with capng} \
		%{subst_with libpcap} \
		%{subst_with macvtap} \
		%{subst_with audit} \
		%{?_with_driver_modules:--with-driver-modules} \
		%{subst_with dtrace} \
		%{?_with_wireshark:--with-wireshark-dissector} \
		--with-loader-nvram=%with_loader_nvram \
		%{subst_with sasl}


%make_build
gzip -9 ChangeLog

%install
%makeinstall_std

make -C examples distclean
install -d -m 0755 %buildroot%_runtimedir/%name
rm -f %buildroot%_libdir/*.{a,la}
rm -f %buildroot%_libdir/%name/*/*.{a,la}

# delete docs
rm -rf %buildroot%_datadir/doc/libvirt-%version

%if_with network
# We don't want to install /etc/libvirt/qemu/networks in the main %files list
# because if the admin wants to delete the default network completely, we don't
# want to end up re-incarnating it on every RPM upgrade.
install -d -m 0755 %buildroot%_datadir/libvirt/networks/
cp %buildroot%_sysconfdir/libvirt/qemu/networks/default.xml \
   %buildroot%_datadir/libvirt/networks/default.xml
rm -f %buildroot%_sysconfdir/libvirt/qemu/networks/default.xml
rm -f %buildroot%_sysconfdir/libvirt/qemu/networks/autostart/default.xml
# Strip auto-generated UUID - we need it generated per-install
sed -i -e "/<uuid>/d" %buildroot%_datadir/libvirt/networks/default.xml
%else
rm -f %buildroot%_sysconfdir/libvirt/qemu/networks/default.xml
rm -f %buildroot%_sysconfdir/libvirt/qemu/networks/autostart/default.xml
%endif

%if_without qemu
rm -f %buildroot%_datadir/augeas/lenses/libvirtd_qemu.aug
rm -f %buildroot%_datadir/augeas/lenses/tests/test_libvirtd_qemu.aug
rm -f %buildroot%_sysconfdir/libvirt/qemu.conf
rm -f %buildroot%_sysconfdir/logrotate.d/libvirtd.qemu
%endif
%if_without lxc
rm -f %buildroot%_datadir/augeas/lenses/libvirtd_lxc.aug
rm -f %buildroot%_datadir/augeas/lenses/tests/test_libvirtd_lxc.aug
rm -f %buildroot%_sysconfdir/libvirt/lxc.conf
rm -f %buildroot%_sysconfdir/logrotate.d/libvirtd.lxc
%endif
%if_without uml
rm -f %buildroot%_sysconfdir/logrotate.d/libvirtd.uml
%endif
%if_without nwfilter
rm -rf %buildroot%_sysconfdir/libvirt/nwfilter
%endif
%if_without libxl
rm -f %buildroot%_sysconfdir/logrotate.d/libvirtd.libxl
%endif
install -pD -m644 libvirtd.tmpfiles %buildroot/lib/tmpfiles.d/libvirtd.conf

# Relocate nss library from %_libdir/libnss_libvirt.so.* to /%_lib/libnss_libvirt.so.* .
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/libnss_libvirt.so.* %buildroot/%_lib/
ln -sf ../../%_lib/libnss_libvirt.so.2 %buildroot%_libdir/libnss_libvirt.so
mv %buildroot%_libdir/libnss_libvirt_guest.so.2 %buildroot/%_lib/
ln -sf ../../%_lib/libnss_libvirt_guest.so.2 %buildroot%_libdir/libnss_libvirt_guest.so

%find_lang %name

%check
cd tests
%make
# These 1 tests don't current work
for i in daemon-conf
do
  rm -f $i
  printf "#!/bin/sh\nexit 0\n" > $i
  chmod +x $i
done
%make check ||:

%pre login-shell
%_sbindir/groupadd -r -f virtlogin

%pre daemon-driver-qemu
%_sbindir/groupadd -r -f %qemu_group
%_sbindir/useradd -M -r -d %_localstatedir/lib/%name -s /bin/false -c "libvirt user" -g %qemu_group %qemu_user >/dev/null 2>&1 || :

%post daemon
%post_service virtlockd
%post_service virtlogd
%post_service libvirtd

%preun daemon
%preun_service libvirtd
%preun_service virtlogd
%preun_service virtlockd


%triggerpostun daemon -- libvirt-daemon < 1.3.0
# In upgrade scenario we must explicitly enable virtlockd/virtlogd
# sockets, if libvirtd is already enabled and start them if
# libvirtd is running, otherwise you'll get failures to start
# guests
if [ $1 -ge 1 ] ; then
    if service libvirtd status; then
        chkconfig virtlogd on && service virtlogd start
        chkconfig virtlockd on && service virtlockd start
    fi
fi

%post daemon-config-network
if [ $1 -eq 1 ]; then
    if [ ! -f %_sysconfdir/libvirt/qemu/networks/default.xml ]; then
	UUID=`/usr/bin/uuidgen`
	sed -e "s,</name>,</name>\n  <uuid>$UUID</uuid>," \
         < %_datadir/libvirt/networks/default.xml \
         > /etc/libvirt/qemu/networks/default.xml
    fi
fi

%post client
%post_service libvirt-guests

%preun client
%preun_service libvirt-guests

%files

%files docs
%doc docs/*.xml
%doc %_datadir/gtk-doc/html/libvirt
%doc examples

%doc docs/html docs/devhelp docs/*.gif


%files client
%_bindir/virsh
%_bindir/virt-xml-validate
%_bindir/virt-pki-validate
%_bindir/virt-host-validate
%_man1dir/virsh.*
%_man1dir/virt-xml-validate.*
%_man1dir/virt-pki-validate.*
%_man1dir/virt-host-validate.*

%config(noreplace) %_sysconfdir/sysconfig/libvirt-guests
%_initdir/libvirt-guests
%_libexecdir/libvirt-guests.sh
%systemd_unitdir/libvirt-guests.service

%files libs -f %name.lang
%doc COPYING COPYING.LESSER
%config(noreplace) %_sysconfdir/libvirt/libvirt.conf
%config(noreplace) %_sysconfdir/libvirt/libvirt-admin.conf
%_libdir/lib*.so.*
%dir %_datadir/libvirt
%dir %_datadir/libvirt/schemas
%dir %_localstatedir/lib/libvirt
%_datadir/libvirt/schemas/*.rng
%_datadir/libvirt/cpu_map.xml

%if_with sasl
%config(noreplace) %_sysconfdir/sasl2/libvirt.conf
%endif

%if_with libvirtd
%files daemon
%dir %attr(0700, root, root) %_sysconfdir/libvirt
%dir %_datadir/libvirt
%dir %attr(0700, root, root) %_localstatedir/log/libvirt
%dir %_runtimedir/%name
%dir %attr(0700, root, root) %_sysconfdir/libvirt/nwfilter
%config(noreplace) %_sysconfdir/sysconfig/libvirtd
%config /lib/tmpfiles.d/libvirtd.conf
%_unitdir/libvirtd.service
%_unitdir/virt-guest-shutdown.target
%_initdir/libvirtd
%config(noreplace) %_sysconfdir/libvirt/libvirtd.conf
/lib/sysctl.d/*
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd

#virtlockd
%config(noreplace) %_sysconfdir/libvirt/qemu-lockd.conf
%config(noreplace) %_sysconfdir/sysconfig/virtlockd
%config(noreplace) %_sysconfdir/libvirt/virtlockd.conf
%_initdir/virtlockd
%_unitdir/virtlockd.*
%_libdir/%name/lock-driver/lockd.so
%_sbindir/virtlockd
%_datadir/augeas/lenses/libvirt_lockd.aug
%_datadir/augeas/lenses/virtlockd.aug
%_datadir/augeas/lenses/tests/test_virtlockd.aug
%_man8dir/virtlockd.*
%_man7dir/virkey*

#virtlogd
%config(noreplace) %_sysconfdir/libvirt/virtlogd.conf
%config(noreplace) %_sysconfdir/sysconfig/virtlogd
%_initdir/virtlogd
%_unitdir/virtlogd.*
%_sbindir/virtlogd
%_datadir/augeas/lenses/tests/test_virtlogd.aug
%_datadir/augeas/lenses/virtlogd.aug
%_man8dir/virtlogd.*

%if_with qemu
%_datadir/augeas/lenses/tests/test_libvirt_lockd.aug
%endif


%_libexecdir/libvirt_iohelper
%_sbindir/libvirtd
%_man8dir/libvirtd.*

%_datadir/augeas/lenses/libvirtd.aug
%_datadir/augeas/lenses/tests/test_libvirtd.aug

%dir %attr(0711, root, root) %_localstatedir/lib/libvirt/images
%dir %attr(0711, root, root) %_localstatedir/lib/libvirt/filesystems
%dir %attr(0711, root, root) %_localstatedir/lib/libvirt/boot
%dir %attr(0700, root, root) %_localstatedir/cache/libvirt
%dir %_libdir/libvirt
%dir %_libdir/libvirt/connection-driver
%dir %_libdir/libvirt/lock-driver

%if_with polkit
%_datadir/polkit-1/actions/org.libvirt.unix.policy
%_datadir/polkit-1/actions/org.libvirt.api.policy
%_datadir/polkit-1/rules.d/50-libvirt.rules
%endif

%if_with network
%files daemon-config-network
%dir %attr(0700, root, root) %_sysconfdir/libvirt/qemu
%dir %attr(0700, root, root) %_sysconfdir/libvirt/qemu/networks
%dir %attr(0700, root, root) %_sysconfdir/libvirt/qemu/networks/autostart
%dir %_datadir/libvirt/networks
%_datadir/libvirt/networks/default.xml
%dir %_runtimedir/%name/network
%dir %attr(0700, root, root) %_localstatedir/lib/libvirt/network
%dir %attr(0755, root, root) %_localstatedir/lib/libvirt/dnsmasq
%endif

%if_with nwfilter
%files daemon-config-nwfilter
%_sysconfdir/libvirt/nwfilter/*.xml
%endif

%if_with driver_modules
%if_with network
%files daemon-driver-network
%_libdir/%name/connection-driver/libvirt_driver_network.so
%_libexecdir/libvirt_leaseshelper
%endif

%if_with udev
%files daemon-driver-nodedev
%_libdir/%name/connection-driver/libvirt_driver_nodedev.so

%files daemon-driver-interface
%_libdir/%name/connection-driver/libvirt_driver_interface.so
%endif #if_with udev

%if_with nwfilter
%files daemon-driver-nwfilter
%_libdir/%name/connection-driver/libvirt_driver_nwfilter.so
%endif

%files daemon-driver-secret
%_libdir/%name/connection-driver/libvirt_driver_secret.so

%files daemon-driver-storage

%files daemon-driver-storage-core
%if_with storage_disk
%_libexecdir/libvirt_parthelper
%endif
%_libdir/%name/connection-driver/libvirt_driver_storage.so
%dir %_libdir/%name/storage-backend

%if_with storage_fs
%files daemon-driver-storage-fs
%_libdir/%name/storage-backend/libvirt_storage_backend_fs.so
%endif

%if_with storage_disk
%files daemon-driver-storage-disk
%_libdir/%name/storage-backend/libvirt_storage_backend_disk.so
%endif

%if_with storage_lvm
%files daemon-driver-storage-logical
%_libdir/%name/storage-backend/libvirt_storage_backend_logical.so
%endif

%if_with storage_scsi
%files daemon-driver-storage-scsi
%_libdir/%name/storage-backend/libvirt_storage_backend_scsi.so
%endif

%if_with storage_iscsi
%files daemon-driver-storage-iscsi
%_libdir/%name/storage-backend/libvirt_storage_backend_iscsi.so
%endif

%if_with storage_mpath
%files daemon-driver-storage-mpath
%_libdir/%name/storage-backend/libvirt_storage_backend_mpath.so
%endif

%if_with storage_gluster
%files daemon-driver-storage-gluster
%_libdir/%name/storage-backend/libvirt_storage_backend_gluster.so
%endif

%if_with storage_rbd
%files daemon-driver-storage-rbd
%_libdir/%name/storage-backend/libvirt_storage_backend_rbd.so
%endif

%if_with storage_sheepdog
%files daemon-driver-storage-sheepdog
%_libdir/%name/storage-backend/libvirt_storage_backend_sheepdog.so
%endif

%if_with storage_zfs
%files daemon-driver-storage-zfs
%_libdir/%name/storage-backend/libvirt_storage_backend_zfs.so
%endif

%if_with qemu
%files daemon-driver-qemu
%_libdir/%name/connection-driver/libvirt_driver_qemu.so
%endif

%if_with lxc
%files daemon-driver-lxc
%_libdir/%name/connection-driver/libvirt_driver_lxc.so
%endif

%if_with uml
%files daemon-driver-uml
%_libdir/%name/connection-driver/libvirt_driver_uml.so
%endif

%if_with xen
%files daemon-driver-xen
%_libdir/%name/connection-driver/libvirt_driver_xen.so
%endif

%if_with libxl
%files daemon-driver-libxl
%_libdir/%name/connection-driver/libvirt_driver_libxl.so
%endif

%if_with vbox
%files daemon-driver-vbox
%_libdir/%name/connection-driver/libvirt_driver_vbox.so
%endif
%endif #driver_modules

%if_with qemu
%files qemu-common
%config(noreplace) %_sysconfdir/libvirt/qemu.conf
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd.qemu
%dir %attr(0750, root, root) %_runtimedir/%name/qemu
%dir %attr(0750, %qemu_user, %qemu_group) %_localstatedir/lib/libvirt/qemu
%dir %attr(0750, %qemu_user, %qemu_group) %_localstatedir/cache/libvirt/qemu
%dir %attr(0700, root, root) %_localstatedir/log/libvirt/qemu
%_datadir/augeas/lenses/libvirtd_qemu.aug
%_datadir/augeas/lenses/tests/test_libvirtd_qemu.aug

%if_with qemu_tcg
%files qemu
%endif
%if_with qemu_kvm
%files kvm
%endif

%endif #if_with qemu

%if_with lxc
%files lxc
%config(noreplace) %_sysconfdir/libvirt/lxc.conf
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd.lxc
%dir %_runtimedir/%name/lxc
%dir %attr(0700, root, root) %_localstatedir/lib/libvirt/lxc
%dir %attr(0700, root, root) %_localstatedir/log/libvirt/lxc
%_datadir/augeas/lenses/libvirtd_lxc.aug
%_datadir/augeas/lenses/tests/test_libvirtd_lxc.aug
%_libexecdir/libvirt_lxc
%endif

%if_with uml
%files uml
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd.uml
%dir %_runtimedir/%name/uml
%dir %attr(0700, root, root) %_localstatedir/lib/libvirt/uml
%dir %attr(0700, root, root) %_localstatedir/log/libvirt/uml
%endif

%if_with xen
%files xen
%if_with libxl
%dir %attr(0700, root, root) %_localstatedir/log/libvirt/libxl
%dir %attr(0700, root, root) %_localstatedir/lib/libvirt/libxl
%config(noreplace) %_sysconfdir/libvirt/libxl*.conf
%config(noreplace) %_sysconfdir/logrotate.d/libvirtd.libxl
%_datadir/augeas/lenses/libvirtd_libxl.aug
%_datadir/augeas/lenses/tests/test_libvirtd_libxl.aug
%endif #if_with libxl
%endif #if_with xen

%if_with vbox
%files vbox
%endif

%if_with sanlock
%files lock-sanlock
%_libdir/libvirt/lock-driver/sanlock.so

%if_with qemu
%config(noreplace) %_sysconfdir/libvirt/qemu-sanlock.conf
%endif

%if_with libxl
%config(noreplace) %_sysconfdir/libvirt/libxl-sanlock.conf
%endif

%_datadir/augeas/lenses/libvirt_sanlock.aug
%_datadir/augeas/lenses/tests/test_libvirt_sanlock.aug
%dir %attr(0770, root, sanlock) %_localstatedir/lib/libvirt/sanlock
%_sbindir/virt-sanlock-cleanup
%_man8dir/virt-sanlock-cleanup.*
%_libexecdir/libvirt_sanlock_helper
%endif #if_with sanlock
%endif #if_with libvirtd

%files admin
%_bindir/virt-admin
%_man1dir/virt-admin.1*

%files  -n nss-%name
/%_lib/libnss_libvirt.so.*
/%_lib/libnss_libvirt_guest.so.*

%if_with wireshark
%files -n wireshark-plugin-%name
%_libdir/wireshark/plugins/%name.so
%endif

%if_with lxc
%if_with login_shell
%files login-shell
%config(noreplace) %_sysconfdir/libvirt/virt-login-shell.conf
%attr(4710, root, virtlogin) %_bindir/virt-login-shell
%_man1dir/virt-login-shell.*
%endif
%endif

%files devel
%_pkgconfigdir/*.pc
%_libdir/*.so
%_includedir/libvirt
%_datadir/libvirt/api

%changelog
