Name: libx264
Version: 148
Release: alt1

Summary: H.264 codec shared library
License: GPL
Group: System/Libraries
Url: http://www.videolan.org/x264.html

Source: %name-%version-%release.tar

BuildRequires: yasm libX11-devel

%description
libx264 is a free library for encoding H264/AVC video streams. The code
is written from scratch.
Encoder features:
- CAVLC/CABAC
- Multi-references
- Intra: all macroblock types (16x16, 8x8, and 4x4 with all
  predictions)
- Inter P: all partitions (from 16x16 down to 4x4)
- Inter B: partitions from 16x16 down to 8x8 (including skip/direct)
- Ratecontrol: constant quantizer, single or multipass ABR, optional
  VBV
- Scene cut detection
- Adaptive B-frame placement
- B-frames as references / arbitrary frame order
- 8x8 and 4x4 adaptive spatial transform
- Lossless mode
- Custom quantization matrices
- Parallel encoding of multiple slices.

This package includes the shared library needed to run x264-based
software.

%package devel
Summary: Development files of H.264 codec library
Group: Development/C
Requires: %name = %version-%release

%description devel
%name is a free library for encoding H264/AVC video streams. The code is
written from scratch.
Encoder features:
- CAVLC/CABAC
- Multi-references
- Intra: all macroblock types (16x16, 8x8, and 4x4 with all
  predictions)
- Inter P: all partitions (from 16x16 down to 4x4)
- Inter B: partitions from 16x16 down to 8x8 (including skip/direct)
- Ratecontrol: constant quantizer, single or multipass ABR, optional
  VBV
- Scene cut detection
- Adaptive B-frame placement
- B-frames as references / arbitrary frame order
- 8x8 and 4x4 adaptive spatial transform
- Lossless mode
- Custom quantization matrices
- Parallel encoding of multiple slices.

This package includes the header files needed to develop lib%name-based
software.

%prep
%setup

%build
%define _optlevel 3
%ifarch %ix86
# prevent use of -mfoo part of CFLAGS on x86 with YASM
export ASFLAGS=' '
%endif

%configure \
	--disable-cli \
    	--enable-debug \
	--enable-pic \
	--enable-shared \
	--bit-depth=8

%make_build 

%install
%make_install DESTDIR=%buildroot install

%ifnarch x86_64
%set_verify_elf_method textrel=relaxed
%endif

%files
%doc doc/*.txt AUTHORS
%_libdir/libx264.so.*

%files devel
%_includedir/x264.h
%_includedir/x264_config.h
%_pkgconfigdir/*
%_libdir/libx264.so

%changelog
