Name: libxcb
Version: 1.12
Release: alt2
Summary: The X C Binding (XCB) library
License: MIT/X11
Group: System/Libraries
Url: http://xorg.freedesktop.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: doxygen fonts-ttf-freefont graphviz libXau-devel libXdmcp-devel xorg-xcbproto-devel >= 1.12
BuildRequires: xsltproc libselinux-devel xorg-util-macros
BuildRequires: python2.7(distutils)

%description
libxcb provides an interface to the X Window System protocol, slated to
replace the current Xlib interface. It has several advantages over
Xlib, including:
  - size: small library and lower memory footprint
  - latency hiding: batch several requests and wait for the replies later
  - direct protocol access: one-to-one mapping between interface and protocol
  - proven thread support: transparently access XCB from multiple threads
  - easy extension implementation: interfaces auto-generated from XML-XCB

Xlib can also use XCB as a transport layer, allowing software to make
requests and receive responses with both, which eases porting to XCB.
However, client programs, libraries, and toolkits will gain the most
benefit from a native XCB port.

%package devel
Summary: XCB Library and Header Files
Group: Development/C
Requires: %name = %version-%release

%description devel
%name-devel contains the libraries and header files needed to
develop programs which make use of %name

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--enable-xinput \
	--enable-selinux \
	--enable-xkb \
	--disable-xprint \
	--disable-static

%make_build

%install
%make DESTDIR=%buildroot htmldir=%_docdir/%name-devel install

%files
%doc NEWS README
%_libdir/*.so.*

%files devel
%doc %_docdir/%name-devel
%_includedir/xcb
%_libdir/*.so
%_pkgconfigdir/*.pc
%_man3dir/*.3*

%changelog
