%define bname xine
%define plugin_version 1.30
%define _optlevel 3

%set_verify_elf_method textrel=relaxed
%define audio_buffer_size 16384
%def_enable build_ffmpeg_ext
%def_enable build_faad
%def_disable build_gdkpixbuf
%def_disable build_imagik
%def_disable build_aalib
%def_disable build_timidity

Name: lib%bname
Version: 1.1.21
Release: alt7
Summary: Free libraries for play video and audio
Summary(ru_RU.UTF-8): Библиотеки для воспроизведения видео и аудио информации
License: GPLv2+
Group: System/Libraries
URL: http://%{bname}hq.de/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar
Patch2: xine-lib-list-dirac.patch
Patch3: xine-lib-1.1.7-configure.patch
#
Patch5: xine-lib-1.1.4-timidity.patch
Patch6: xine-lib-1.1.2-ext_mad.patch
Patch7: xine-lib-1.1.15-mpgaudio_priority.patch
Patch8: xine-lib-1.1.15-id3.patch
Patch9: xine-lib-1.1.20-add_ff_decoders.patch
Patch10: xine-lib-1.1.14-xine-list.patch
Patch11: xine-lib-1.1.20-demux_qt.patch
Patch12: xine-lib-1.1.17-alt-tmpdir.patch
Patch13: xine-lib-1.1.17-alt-ffmpeg-headers.patch
Patch14: xine-lib-1.1.17-alt-ff-check-extradata.patch
Patch15: xine-lib-1.1.21-alt-crash-workaround.patch
# SuSE
Patch101: xine-configure.diff
Patch102: xine-lib-1.1.19-assert.patch
Patch103: xine-lib-1.1.19-demuxcheckfor_mad_ffmpeg.patch
Patch104: xine-lib-1.1.19-glitch-free-pulseaudio.patch
#
Patch107: xine-lib-libdvdread_udf.diff
Patch108: xine-lib-various-noncrippled.diff
# FC
Patch201: xine-lib-1.1.1-deepbind-939.patch
Patch202: xine-lib-1.1.4-optflags.patch
# Debian
Patch300: fix-libav9-ftbfs.patch

# Automatically added by buildreq on Wed Apr 20 2011 (-bi)
# optimized out: aalib elfutils fontconfig fonts-type1-urw ghostscript-classic glib2-devel gnome-vfs libGConf-devel libGL-devel libGLU-devel libX11-devel libXext-devel libXv-devel libavahi-glib libavcore-devel libavutil-devel libdbus-glib libdvdread-devel libgpg-error libogg-devel libopencore-amrnb0 libopencore-amrwb0 libxcb-devel pkg-config python-base ruby samba-winbind-clients xorg-videoproto-devel xorg-xextproto-devel xorg-xproto-devel xz
#BuildRequires: aalib-devel cm-super-fonts-pfb fonts-ttf-dejavu fonts-ttf-droid fonts-ttf-java-1.6.0-sun fonts-ttf-reduce fonts-ttf-vera fonts-type1-cm-super-pfb fonts-type1-dmtr40in ghostscript-common glibc-devel-static gnome-vfs-devel imake libSDL-devel libXinerama-devel libXvMC-devel liba52-devel libalsa-devel libavcodec-devel libcaca-devel libdca-devel libdvdnav-devel libfaad-devel libflac-devel libfreetype-devel libgpm-devel libjack-devel libjpeg-devel libmad-devel libmng-devel libmodplug-devel libmpcdec-devel libpostproc-devel libpulseaudio-devel libslang-devel libsmbclient-devel libspeex-devel libtheora-devel libtimidity-devel libv4l-devel libvorbis-devel libwavpack-devel module-init-tools rpm-build-ruby transfig xorg-cf-files zlib-devel
BuildRequires: glibc-devel gnome-vfs-devel
BuildRequires: libSDL-devel libXinerama-devel libXvMC-devel liba52-devel libalsa-devel
BuildRequires: libcaca-devel libdca-devel libdvdnav-devel libbluray-devel
BuildRequires: libflac-devel libfreetype-devel fontconfig-devel
BuildRequires: libgpm-devel libjack-devel libjpeg-devel
BuildRequires: libmad-devel libmng-devel libmodplug-devel libmpcdec-devel libpostproc-devel
BuildRequires: libpulseaudio-devel libslang-devel libsmbclient-devel libspeex-devel
BuildRequires: libtheora-devel libv4l-devel libvorbis-devel libwavpack-devel
BuildRequires: transfig zlib-devel
#BuildRequires: libcdio-devel libvcd-devel
#BuildRequires: jackit-devel
%if_enabled build_faad
BuildRequires: libfaad-devel
%endif
%if_enabled build_timidity
BuildRequires: libtimidity-devel
%endif
%if_enabled build_ffmpeg_ext
BuildRequires: libavcodec-devel
%endif
%if_enabled build_imagik
BuildRequires: libImageMagick-devel
%endif
%if_enabled build_aalib
BuildRequires: aalib-devel
%endif

%description
%name is a free gpl-licensed video player libraries and plugins for
unix-like systems. It supports mpeg-2 and mpeg-1 streams as well as AVI
files that contain MS MPEG-4 / DivX / XviD Video.

%description -l ru_RU.UTF-8
%name - свободные библиотеки и модули для воспроизведения видео. Они
поддерживают mpeg-2 и mpeg-1 потоки, а также AVI файлы, содержащие
MS MPEG4 или DivX/XviD видео. Также с помощью этих библиотек вы можете
смотреть фильмы на DVD.

%package devel
Summary: Includes for %bname development
Summary(ru_RU.UTF-8): Заголовочные файлы для разработки под %bname
Group: Development/Other
Requires: %name = %version-%release

%description devel
This package contains the include files for development for %bname video
output libraries.

%description devel -l ru_RU.UTF-8
В этом пакете содержатся .h файлы для разработки приложений с
использованием библиотек %bname.

%package -n %bname-plugin-gnomevfs
Summary: gnome-vfs input plugin for %bname
Group: System/Libraries
PreReq: %name = %version-%release
Provides: %bname-plugin-input-gnomevfs = %version
Obsoletes: %bname-plugin-input-gnomevfs < %version

%description -n %bname-plugin-gnomevfs
gnome-vfs input plugin for %bname.

%package -n %bname-plugin-samba
Summary: samba input plugin for %bname
Group: System/Libraries
PreReq: %name = %version-%release

%description -n %bname-plugin-samba
samba input plugin for %bname.

%prep
%setup -q
%patch2 -p1
%patch3 -p1
#
%if_enabled build_timidity
%patch5 -p1
%endif
%patch6 -p1
#%patch7 -p1
%patch8 -p1
%patch9 -p1
#%patch10 -p1
%patch11 -p1
#%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
#
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
#
%patch107 -p1
%patch108 -p0
%patch201 -p1
%patch202 -p1
#
%patch300 -p1

%if_enabled build_ffmpeg_ext
mv src/libffmpeg/libavcodec/dvdata.h src/libffmpeg/libavcodec/dvdata.h~
rm -rf src/libffmpeg/libav*/*.h
mv src/libffmpeg/libavcodec/dvdata.h~ src/libffmpeg/libavcodec/dvdata.h
%endif

sed -i 's|8192|%audio_buffer_size|g' src/xine-engine/audio_decoder.c
sed -i 's|-O3|-O%_optlevel|g' m4/optimizations.m4

%autoreconf

%build
SAMBA_CFLAGS=`pkg-config --cflags smbclient`
%add_optflags -fno-strict-aliasing -fno-force-addr $SAMBA_CFLAGS
%if_enabled build_ffmpeg_ext
%add_optflags -I%_includedir/ffmpeg
%endif
#touch ABOUT-NLS config.rpath
%configure \
%if_enabled build_timidity
	--enable-midi \
%endif
%if_enabled build_ffmpeg_ext
	--with-external-ffmpeg \
%else
	--without-external-ffmpeg \
%endif
	--with-external-a52dec \
	--with-external-libmpcdec \
	--with-external-dvdnav \
	--with-external-libmad \
%if_enabled build_faad
	--with-external-libfaad \
%else
	--disable-faad \
%endif
%if_disabled build_gdkpixbuf
	--disable-gdkpixbuf \
%endif
%if_disabled build_imagik
	--without-imagemagick \
%endif
%if_disabled build_aalib
	--disable-aalib \
%endif
	--with-external-libdts \
	--with-xv-path=%_libdir \
	--with-libflac \
	--with-wavpack \
	--enable-modplug \
	--disable-nosefart \
	--disable-vidix \
	--disable-vcd \
	--disable-oss \
	--disable-w32dll \
	--disable-fb \
	--disable-dxr3 \
	--disable-syncfb \
	--with-freetype \
	--enable-antialiasing \
	--with-fontconfig \
	--enable-ipv6 \
	--disable-rpath \
	--disable-static \
	--enable-shared
#	--disable-mad \
#	--with-xvmc-lib=XvMC \
#	--with-xxmc-lib=XvMCWdisabled \
#	--disable-dvdnavtest \
#	--with-internal-vcdlibs \
%make_build

%install
%make DESTDIR=%buildroot docdir=%_docdir/%name-devel-%version htmldir=%_docdir/%name-devel-%version/html install

%find_lang %{name}1

%files -f %{name}1.lang
%_libdir/%{name}*.so.*
%dir %_libdir/%bname
%dir %_libdir/%bname/plugins
%_libdir/%bname/plugins/%plugin_version
%exclude %_libdir/%bname/plugins/%plugin_version/%{bname}plug_inp_gnome_vfs.so
%exclude %_libdir/%bname/plugins/%plugin_version/%{bname}plug_inp_smb.so
%_datadir/%bname
%_man5dir/*

%files devel
%doc %_docdir/%name-devel-%version
%_includedir/%{bname}*
%_libdir/%{name}*.so
%_bindir/*
%_datadir/aclocal/*
%_pkgconfigdir/*.pc
%_man1dir/*

%files -n %bname-plugin-gnomevfs
%_libdir/%bname/plugins/%plugin_version/%{bname}plug_inp_gnome_vfs.so

%files -n %bname-plugin-samba
%_libdir/%bname/plugins/%plugin_version/%{bname}plug_inp_smb.so

%changelog
